/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum AddressType {
    UNKNOWN(0),
    IP_V4(1),
    IP_V6(2);

    public final int value;

    private AddressType(int value) {
        this.value = value;
    }

    public static AddressType from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return IP_V4;
            }
            case 2: {
                return IP_V6;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }
}

