/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public class Array<T>
implements Iterable<T> {
    public final int size;
    public final List<T> values;

    public Array(ByteBuffer buffer, Optional<Integer> size, Parser<? extends T> parser) throws InvalidPacketException {
        this.size = size.orElseGet(() -> (int)BufferUtils.uint32((ByteBuffer)buffer));
        ArrayList<T> values = new ArrayList<T>(this.size);
        for (int i = 0; i < this.size; ++i) {
            values.add(parser.parse(buffer));
        }
        this.values = Collections.unmodifiableList(values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size).add("values", this.values).toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(ByteBuffer var1) throws InvalidPacketException;
    }
}

