/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SampleDatagram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketHandler
extends SimpleChannelInboundHandler<DefaultAddressedEnvelope<SampleDatagram, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(PacketHandler.class);
    private final AsyncDispatcher<TelemetryMessage> dispatcher;

    public PacketHandler(AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    protected void channelRead0(ChannelHandlerContext ctx, DefaultAddressedEnvelope<SampleDatagram, InetSocketAddress> packet) throws Exception {
        LOG.trace("Got packet: {}", packet);
        BasicOutputBuffer output = new BasicOutputBuffer();
        try (BsonBinaryWriter bsonWriter = new BsonBinaryWriter((BsonOutput)output);){
            bsonWriter.writeStartDocument();
            bsonWriter.writeName("time");
            bsonWriter.writeInt64(System.currentTimeMillis());
            bsonWriter.writeName("data");
            ((SampleDatagram)packet.content()).version.datagram.writeBson((BsonWriter)bsonWriter);
            bsonWriter.writeEndDocument();
        }
        TelemetryMessage msg = new TelemetryMessage((InetSocketAddress)packet.sender(), ((ByteBuf)output.getByteBuffers().get(0)).asNIO());
        CompletableFuture future = this.dispatcher.send((Message)msg);
        future.handle((result, ex) -> {
            if (ex != null) {
                ctx.fireExceptionCaught(ex);
            }
            return result;
        });
    }
}

