/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.InvokeAtType;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="invoke")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="service-configuration.xsd")
public class Invoke
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="method")
    private String m_method;
    @XmlAttribute(name="pass")
    private Integer m_pass = 0;
    @XmlAttribute(name="at")
    private InvokeAtType m_at;
    @XmlElement(name="argument")
    private List<Argument> m_arguments = new ArrayList<Argument>();

    public Invoke() {
    }

    public Invoke(InvokeAtType type, Integer pass, String method, List<Argument> arguments) {
        this.setAt(type);
        this.setPass(pass);
        this.setMethod(method);
        this.setArguments(arguments);
    }

    public String getMethod() {
        return this.m_method;
    }

    public void setMethod(String method) {
        this.m_method = ConfigUtils.assertNotEmpty(method, "method");
    }

    public int getPass() {
        return this.m_pass == null ? 0 : this.m_pass;
    }

    public void setPass(int pass) {
        this.m_pass = pass;
    }

    public InvokeAtType getAt() {
        return this.m_at;
    }

    public void setAt(InvokeAtType at) {
        this.m_at = ConfigUtils.assertNotNull(at, "at");
    }

    public List<Argument> getArguments() {
        return this.m_arguments;
    }

    public void setArguments(List<Argument> arguments) {
        if (arguments == this.m_arguments) {
            return;
        }
        this.m_arguments.clear();
        if (arguments != null) {
            this.m_arguments.addAll(arguments);
        }
    }

    public void addArgument(Argument argument) {
        this.m_arguments.add(argument);
    }

    public boolean removeArgument(Argument argument) {
        return this.m_arguments.remove(argument);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_method, this.m_pass, this.m_at, this.m_arguments});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Invoke) {
            Invoke that = (Invoke)obj;
            return Objects.equals(this.m_method, that.m_method) && Objects.equals(this.m_pass, that.m_pass) && Objects.equals((Object)this.m_at, (Object)that.m_at) && Objects.equals(this.m_arguments, that.m_arguments);
        }
        return false;
    }
}

