/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.lookup;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.BlockingServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.SimpleServiceLookup;

public class ServiceLookupBuilder {
    public static final long GRACE_PERIOD_MS = Long.getLong("org.opennms.core.soa.lookup.gracePeriodMs", TimeUnit.MINUTES.toMillis(5L));
    public static final long WAIT_PERIOD_MS = Long.getLong("org.opennms.core.soa.lookup.gracePeriodMs", TimeUnit.MINUTES.toMillis(1L));
    public static final long LOOKUP_DELAY_MS = Long.getLong("org.opennms.core.soa.lookup.lookupDelayMs", TimeUnit.SECONDS.toMillis(5L));
    private final ServiceRegistry registry;
    private long gracePeriodInMs;
    private long sleepTimeInMs;
    private Supplier<Long> upTimeSupplier;

    public ServiceLookupBuilder(ServiceRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    public ServiceLookupBuilder blocking() {
        return this.blocking(GRACE_PERIOD_MS, LOOKUP_DELAY_MS, () -> ManagementFactory.getRuntimeMXBean().getUptime());
    }

    public ServiceLookupBuilder blocking(long gracePeriodInMs, long sleepTimeInMs, Supplier<Long> upTimeSupplier) {
        Objects.requireNonNull(upTimeSupplier);
        this.gracePeriodInMs = gracePeriodInMs;
        this.sleepTimeInMs = sleepTimeInMs;
        this.upTimeSupplier = Objects.requireNonNull(upTimeSupplier);
        return this;
    }

    public ServiceLookup build() {
        if (this.upTimeSupplier != null) {
            BlockingServiceLookup lookup = new BlockingServiceLookup(this.registry);
            lookup.setGracePeriodInMs(this.gracePeriodInMs);
            lookup.setLookupDelayMs(this.sleepTimeInMs);
            lookup.setUptimeSupplier(this.upTimeSupplier);
            return lookup;
        }
        return new SimpleServiceLookup(this.registry);
    }
}

