/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.lookup;

import java.util.Objects;
import java.util.function.Supplier;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.SimpleServiceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingServiceLookup
implements ServiceLookup {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingServiceLookup.class);
    private final ServiceLookup delegate;
    private long gracePeriodInMs;
    private Supplier<Long> uptimeSupplier;
    private long lookupDelayMs;

    public BlockingServiceLookup(ServiceRegistry registry) {
        Objects.requireNonNull(registry);
        this.delegate = new SimpleServiceLookup(registry);
    }

    @Override
    public <T> T lookup(Class<T> serviceClass) {
        return this.lookup(serviceClass, null);
    }

    @Override
    public <T> T lookup(Class<T> serviceClass, String filter) {
        Objects.requireNonNull(serviceClass);
        T service = this.delegate.lookup(serviceClass, filter);
        if (service != null) {
            return service;
        }
        long waitUntil = System.currentTimeMillis() + ServiceLookupBuilder.WAIT_PERIOD_MS;
        while (this.uptimeSupplier.get() < this.gracePeriodInMs && System.currentTimeMillis() < waitUntil) {
            try {
                Thread.sleep(this.lookupDelayMs);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for service of type " + serviceClass + " to become available in the service registry. Aborting.");
                return null;
            }
            service = this.delegate.lookup(serviceClass, filter);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    void setGracePeriodInMs(long gracePeriodInMs) {
        this.gracePeriodInMs = gracePeriodInMs;
    }

    void setUptimeSupplier(Supplier<Long> uptimeSupplier) {
        this.uptimeSupplier = uptimeSupplier;
    }

    void setLookupDelayMs(long lookupDelayMs) {
        this.lookupDelayMs = lookupDelayMs;
    }
}

