/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.flow.ie.RecordProvider;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Value;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.UnsignedValue;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.DataRecord;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.DataSet;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.FlowSet;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.OptionsTemplateRecord;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.OptionsTemplateSet;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Record;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.TemplateSet;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;
import org.opennms.netmgt.telemetry.listeners.flow.session.Template;

public final class Packet
implements Iterable<FlowSet<?>>,
RecordProvider {
    public final InetSocketAddress sender;
    public final Header header;
    public final List<TemplateSet> templateSets;
    public final List<OptionsTemplateSet> optionTemplateSets;
    public final List<DataSet> dataSets;

    public Packet(Session session, InetSocketAddress sender, Header header, ByteBuffer buffer) throws InvalidPacketException {
        this.sender = Objects.requireNonNull(sender);
        this.header = Objects.requireNonNull(header);
        LinkedList<TemplateSet> templateSets = new LinkedList<TemplateSet>();
        LinkedList<OptionsTemplateSet> optionTemplateSets = new LinkedList<OptionsTemplateSet>();
        LinkedList<DataSet> dataSets = new LinkedList<DataSet>();
        block5: while (buffer.hasRemaining()) {
            ByteBuffer headerBuffer = BufferUtils.slice((ByteBuffer)buffer, (int)4);
            FlowSetHeader setHeader = new FlowSetHeader(headerBuffer);
            ByteBuffer payloadBuffer = BufferUtils.slice((ByteBuffer)buffer, (int)(setHeader.length - 4));
            switch (setHeader.getType()) {
                case TEMPLATE_SET: {
                    TemplateSet templateSet = new TemplateSet(this, setHeader, payloadBuffer);
                    for (Record record : templateSet) {
                        if (record.header.fieldCount == 0) {
                            if (record.header.templateId == 2) {
                                session.removeAllTemplate(this.header.observationDomainId, Template.Type.TEMPLATE);
                                continue;
                            }
                            if (record.header.fieldCount != 0) continue;
                            session.removeTemplate(this.header.observationDomainId, record.header.templateId);
                            continue;
                        }
                        session.addTemplate(this.header.observationDomainId, Template.builder(record.header.templateId, Template.Type.TEMPLATE).withFields(record.fields).build());
                    }
                    templateSets.add(templateSet);
                    break;
                }
                case OPTIONS_TEMPLATE_SET: {
                    OptionsTemplateSet optionsTemplateSet = new OptionsTemplateSet(this, setHeader, payloadBuffer);
                    for (Record record : optionsTemplateSet) {
                        if (((OptionsTemplateRecord)record).header.fieldCount == 0) {
                            if (((OptionsTemplateRecord)record).header.templateId == 3) {
                                session.removeAllTemplate(this.header.observationDomainId, Template.Type.OPTIONS_TEMPLATE);
                                continue;
                            }
                            if (((OptionsTemplateRecord)record).header.fieldCount != 0) continue;
                            session.removeTemplate(this.header.observationDomainId, ((OptionsTemplateRecord)record).header.templateId);
                            continue;
                        }
                        session.addTemplate(this.header.observationDomainId, Template.builder(((OptionsTemplateRecord)record).header.templateId, Template.Type.OPTIONS_TEMPLATE).withScopes(((OptionsTemplateRecord)record).scopes).withFields(((OptionsTemplateRecord)record).fields).build());
                    }
                    optionTemplateSets.add(optionsTemplateSet);
                    break;
                }
                case DATA_SET: {
                    Session.Resolver resolver = session.getResolver(header.observationDomainId);
                    DataSet dataSet = new DataSet(this, setHeader, resolver, payloadBuffer);
                    if (dataSet.template.type == Template.Type.OPTIONS_TEMPLATE) {
                        for (DataRecord record : dataSet) {
                            session.addOptions(this.header.observationDomainId, dataSet.template.id, record.scopes, record.fields);
                        }
                        continue block5;
                    }
                    dataSets.add(dataSet);
                    break;
                }
                default: {
                    throw new InvalidPacketException(buffer, "Invalid Set ID: %d", setHeader.setId);
                }
            }
        }
        this.templateSets = Collections.unmodifiableList(templateSets);
        this.optionTemplateSets = Collections.unmodifiableList(optionTemplateSets);
        this.dataSets = Collections.unmodifiableList(dataSets);
    }

    @Override
    public Iterator<FlowSet<?>> iterator() {
        return Iterators.concat(this.templateSets.iterator(), this.optionTemplateSets.iterator(), this.dataSets.iterator());
    }

    @Override
    public Stream<Iterable<Value<?>>> getRecords() {
        int recordCount = this.dataSets.stream().mapToInt(s -> s.records.size()).sum();
        return this.dataSets.stream().flatMap(s -> s.records.stream()).map(r -> Iterables.concat((Iterable)ImmutableList.of((Object)new UnsignedValue("@recordCount", recordCount), (Object)new UnsignedValue("@sequenceNumber", this.header.sequenceNumber), (Object)new UnsignedValue("@exportTime", this.header.exportTime), (Object)new UnsignedValue("@observationDomainId", this.header.observationDomainId)), r.fields, r.options));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("templateSets", this.templateSets).add("optionTemplateSets", this.optionTemplateSets).add("dataTemplateSets", this.dataSets).toString();
    }
}

