/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;
import org.opennms.netmgt.telemetry.listeners.flow.session.UdpSessionManager;

public class UdpPacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final UdpSessionManager sessionManager;

    public UdpPacketDecoder(UdpSessionManager sessionManager) {
        this.sessionManager = Objects.requireNonNull(sessionManager);
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        Session session = this.sessionManager.getSession((InetSocketAddress)msg.sender(), (InetSocketAddress)msg.recipient());
        ByteBuf buf = (ByteBuf)msg.content();
        ByteBuffer headerBuffer = buf.readSlice(16).nioBuffer();
        Header header = new Header(headerBuffer);
        ByteBuffer payloadBuffer = buf.readSlice(header.length - 16).nioBuffer();
        Packet packet = new Packet(session, (InetSocketAddress)msg.sender(), header, payloadBuffer);
        out.add(new DefaultAddressedEnvelope((Object)packet, msg.recipient(), msg.sender()));
    }
}

