/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SpecificComparator;

public final class MergeableSpecific
implements Comparable<String> {
    private String m_specific;
    private static final SpecificComparator m_comparator = new SpecificComparator();
    private byte[] m_value;

    public MergeableSpecific(String specific) {
        this.m_specific = specific;
        InetAddress addr = InetAddressUtils.addr((String)specific);
        if (addr == null) {
            throw new IllegalArgumentException("Unable to get InetAddress for " + specific);
        }
        this.m_value = addr.getAddress();
    }

    @Override
    public int compareTo(String specific) {
        return m_comparator.compare(this.m_specific, specific);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MergeableSpecific)) {
            return false;
        }
        MergeableSpecific that = (MergeableSpecific)o;
        return new EqualsBuilder().append(this.getValue(), that.getValue()).append((Object)this.getSpecific(), (Object)that.getSpecific()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 51).append(this.getValue()).append((Object)this.getSpecific()).toHashCode();
    }

    public String getSpecific() {
        return this.m_specific;
    }

    public void setSpecific(String specific) {
        this.m_specific = specific;
    }

    public String toString() {
        return this.m_specific;
    }

    public byte[] getValue() {
        return this.m_value;
    }
}

