/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.DataCollectionConfigParser;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.DatacollectionGroup;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.datacollection.SystemDefChoice;
import org.opennms.netmgt.config.datacollection.Systems;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataCollectionConfigDao
extends AbstractJaxbConfigDao<DatacollectionConfig, DatacollectionConfig>
implements DataCollectionConfigDao {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultDataCollectionConfigDao.class);
    private String m_configDirectory;
    private List<String> dataCollectionGroups = new ArrayList<String>();
    private Map<String, ResourceType> resourceTypes = new HashMap<String, ResourceType>();

    public DefaultDataCollectionConfigDao() {
        super(DatacollectionConfig.class, "data-collection");
    }

    protected DatacollectionConfig translateConfig(DatacollectionConfig config) {
        DataCollectionConfigParser parser = new DataCollectionConfigParser(this.getConfigDirectory());
        this.resourceTypes.clear();
        Map<String, DatacollectionGroup> externalGroupMap = parser.getExternalGroupMap();
        SnmpCollection resourceTypeCollection = new SnmpCollection();
        resourceTypeCollection.setName("__resource_type_collection");
        for (SnmpCollection collection : config.getSnmpCollections()) {
            parser.parseCollection(collection);
            for (ResourceType rt : collection.getResourceTypes()) {
                resourceTypeCollection.addResourceType(rt);
                this.resourceTypes.put(rt.getName(), rt);
            }
            collection.setResourceTypes(new ArrayList());
            for (IncludeCollection include : collection.getIncludeCollections()) {
                if (include.getDataCollectionGroup() == null) continue;
                DatacollectionGroup group = externalGroupMap.get(include.getDataCollectionGroup());
                for (ResourceType rt : group.getResourceTypes()) {
                    resourceTypeCollection.addResourceType(rt);
                    this.resourceTypes.put(rt.getName(), rt);
                }
            }
        }
        resourceTypeCollection.setGroups(new Groups());
        resourceTypeCollection.setSystems(new Systems());
        config.insertSnmpCollection(resourceTypeCollection);
        this.dataCollectionGroups.clear();
        this.dataCollectionGroups.addAll(parser.getExternalGroupMap().keySet());
        this.validateResourceTypes(config.getSnmpCollections(), this.resourceTypes.keySet());
        return config;
    }

    public void setConfigDirectory(String configDirectory) {
        this.m_configDirectory = configDirectory;
    }

    public String getConfigDirectory() {
        if (this.m_configDirectory == null) {
            StringBuilder sb = new StringBuilder(ConfigFileConstants.getHome());
            sb.append(File.separator);
            sb.append("etc");
            sb.append(File.separator);
            sb.append("datacollection");
            sb.append(File.separator);
            this.m_configDirectory = sb.toString();
        }
        return this.m_configDirectory;
    }

    public String getSnmpStorageFlag(String collectionName) {
        SnmpCollection collection = DefaultDataCollectionConfigDao.getSnmpCollection((FileReloadContainer<DatacollectionConfig>)this.getContainer(), collectionName);
        return collection == null ? null : collection.getSnmpStorageFlag();
    }

    public List<MibObject> getMibObjectList(String cName, String aSysoid, String anAddress, int ifType) {
        LOG.debug("getMibObjectList: collection: {} sysoid: {} address: {} ifType: {}", new Object[]{cName, aSysoid, anAddress, ifType});
        if (aSysoid == null) {
            LOG.debug("getMibObjectList: aSysoid parameter is NULL...");
            return new ArrayList<MibObject>();
        }
        SnmpCollection collection = DefaultDataCollectionConfigDao.getSnmpCollection((FileReloadContainer<DatacollectionConfig>)this.getContainer(), cName);
        if (collection == null) {
            return Collections.emptyList();
        }
        Systems systems = collection.getSystems();
        if (systems == null) {
            return Collections.emptyList();
        }
        ArrayList<SystemDef> systemList = new ArrayList<SystemDef>();
        for (SystemDef system : systems.getSystemDefs()) {
            if (!this.systemDefMatches(system, aSysoid, anAddress)) continue;
            LOG.debug("getMibObjectList: MATCH!! adding system '{}'", (Object)system.getName());
            systemList.add(system);
        }
        ArrayList<MibObject> mibObjectList = new ArrayList<MibObject>();
        for (SystemDef system : systemList) {
            for (String grpName : system.getCollect().getIncludeGroups()) {
                this.processGroupName(cName, grpName, ifType, mibObjectList);
            }
        }
        return mibObjectList;
    }

    public List<MibObjProperty> getMibObjProperties(String cName, String aSysoid, String anAddress) {
        LOG.debug("getMibObjProperties: collection: {} sysoid: {} address: {}", new Object[]{cName, aSysoid, anAddress});
        if (aSysoid == null) {
            LOG.debug("getMibObjProperties: aSysoid parameter is NULL...");
            return new ArrayList<MibObjProperty>();
        }
        SnmpCollection collection = DefaultDataCollectionConfigDao.getSnmpCollection((FileReloadContainer<DatacollectionConfig>)this.getContainer(), cName);
        if (collection == null) {
            return Collections.emptyList();
        }
        Systems systems = collection.getSystems();
        if (systems == null) {
            return Collections.emptyList();
        }
        ArrayList<SystemDef> systemList = new ArrayList<SystemDef>();
        for (SystemDef system : systems.getSystemDefs()) {
            if (!this.systemDefMatches(system, aSysoid, anAddress)) continue;
            systemList.add(system);
        }
        ArrayList<MibObjProperty> mibProperties = new ArrayList<MibObjProperty>();
        for (SystemDef system : systemList) {
            for (String grpName : system.getCollect().getIncludeGroups()) {
                this.processGroupForProperties(cName, grpName, mibProperties);
            }
        }
        return mibProperties;
    }

    public Map<String, ResourceType> getConfiguredResourceTypes() {
        return Collections.unmodifiableMap(this.resourceTypes);
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    public int getStep(String collectionName) {
        SnmpCollection collection = DefaultDataCollectionConfigDao.getSnmpCollection((FileReloadContainer<DatacollectionConfig>)this.getContainer(), collectionName);
        return collection == null ? -1 : collection.getRrd().getStep();
    }

    public List<String> getRRAList(String collectionName) {
        SnmpCollection collection = DefaultDataCollectionConfigDao.getSnmpCollection((FileReloadContainer<DatacollectionConfig>)this.getContainer(), collectionName);
        return collection == null ? null : collection.getRrd().getRras();
    }

    public String getRrdPath() {
        String rrdPath = ((DatacollectionConfig)this.getContainer().getObject()).getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            return rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }

    private static SnmpCollection getSnmpCollection(FileReloadContainer<DatacollectionConfig> container, String collectionName) {
        for (SnmpCollection collection : ((DatacollectionConfig)container.getObject()).getSnmpCollections()) {
            if (!collection.getName().equals(collectionName)) continue;
            return collection;
        }
        return null;
    }

    private void processGroupName(String cName, String groupName, int ifType, List<MibObject> mibObjectList) {
        Map<String, Group> groupMap = DefaultDataCollectionConfigDao.getCollectionGroupMap((FileReloadContainer<DatacollectionConfig>)this.getContainer()).get(cName);
        Group group = groupMap.get(groupName);
        if (group == null) {
            LOG.warn("DataCollectionConfigFactory.processGroupName: unable to retrieve group information for group name '{}': check DataCollection.xml file.", (Object)groupName);
            return;
        }
        LOG.debug("processGroupName:  processing group: {} groupIfType: {} ifType: {}", new Object[]{groupName, group.getIfType(), ifType});
        for (String includeGroup : group.getIncludeGroups()) {
            this.processGroupName(cName, includeGroup, ifType, mibObjectList);
        }
        String ifTypeStr = String.valueOf(ifType);
        String groupIfType = group.getIfType();
        boolean addGroupObjects = false;
        if (ifType == -1) {
            if (groupIfType.equals("ignore")) {
                addGroupObjects = true;
            }
        } else if (groupIfType.equals("all")) {
            addGroupObjects = true;
        } else if (!"ignore".equals(groupIfType)) {
            if (ifType == -2) {
                addGroupObjects = true;
            } else {
                boolean isList = false;
                if (groupIfType.indexOf(44) != -1) {
                    isList = true;
                }
                if (!isList) {
                    if (ifTypeStr.equals(groupIfType)) {
                        addGroupObjects = true;
                    }
                } else {
                    int tmpIndex = groupIfType.indexOf(ifTypeStr);
                    while (tmpIndex != -1) {
                        groupIfType = groupIfType.substring(tmpIndex);
                        int nextComma = groupIfType.indexOf(44);
                        String parsedType = null;
                        parsedType = nextComma == -1 ? groupIfType : groupIfType.substring(0, nextComma);
                        if (ifTypeStr.equals(parsedType)) {
                            addGroupObjects = true;
                            break;
                        }
                        if (nextComma == -1) break;
                        groupIfType = groupIfType.substring(nextComma + 1);
                        tmpIndex = groupIfType.indexOf(ifTypeStr);
                    }
                }
            }
        }
        if (addGroupObjects) {
            LOG.debug("processGroupName: OIDs from group '{}:{}' are included for ifType: {}", new Object[]{group.getName(), group.getIfType(), ifType});
            this.processObjectList(groupName, groupIfType, group.getMibObjs(), mibObjectList);
        } else {
            LOG.debug("processGroupName: OIDs from group '{}:{}' are excluded for ifType: {}", new Object[]{group.getName(), group.getIfType(), ifType});
        }
    }

    private void processGroupForProperties(String cName, String groupName, List<MibObjProperty> mibObjProperties) {
        Map<String, Group> groupMap = DefaultDataCollectionConfigDao.getCollectionGroupMap((FileReloadContainer<DatacollectionConfig>)this.getContainer()).get(cName);
        Group group = groupMap.get(groupName);
        if (group == null) {
            LOG.warn("processGroupForProperties: unable to retrieve group information for group name '{}': check DataCollection.xml file.", (Object)groupName);
            return;
        }
        for (String includeGroup : group.getIncludeGroups()) {
            this.processGroupForProperties(cName, includeGroup, mibObjProperties);
        }
        group.getProperties().forEach(p -> p.setGroupName(groupName));
        mibObjProperties.addAll(group.getProperties());
    }

    private void processObjectList(String groupName, String groupIfType, List<MibObj> objectList, List<MibObject> mibObjectList) {
        for (MibObj mibObj : objectList) {
            MibObject aMibObject = new MibObject();
            aMibObject.setGroupName(groupName);
            aMibObject.setGroupIfType(groupIfType);
            aMibObject.setOid(mibObj.getOid());
            aMibObject.setAlias(mibObj.getAlias());
            aMibObject.setType(mibObj.getType());
            aMibObject.setInstance(mibObj.getInstance());
            aMibObject.setMaxval(mibObj.getMaxval());
            aMibObject.setMinval(mibObj.getMinval());
            ResourceType resourceType = this.getConfiguredResourceTypes().get(mibObj.getInstance());
            if (resourceType != null) {
                aMibObject.setResourceType(resourceType);
            }
            if (mibObjectList.contains(aMibObject)) continue;
            mibObjectList.add(aMibObject);
        }
    }

    private static Map<String, Map<String, Group>> getCollectionGroupMap(FileReloadContainer<DatacollectionConfig> container) {
        HashMap collectionGroupMap = new HashMap();
        for (SnmpCollection collection : ((DatacollectionConfig)container.getObject()).getSnmpCollections()) {
            HashMap<String, Group> groupMap = new HashMap<String, Group>();
            Groups groups = collection.getGroups();
            if (groups != null) {
                for (Group group : groups.getGroups()) {
                    groupMap.put(group.getName(), group);
                }
            }
            collectionGroupMap.put(collection.getName(), groupMap);
        }
        return Collections.unmodifiableMap(collectionGroupMap);
    }

    private void validateResourceTypes(Collection<SnmpCollection> snmpCollections, Set<String> allowedResourceTypes) {
        String configuredString = allowedResourceTypes.size() == 0 ? "(none)" : StringUtils.join(allowedResourceTypes, (String)", ");
        String allowableValues = "any positive number, 'ifIndex', or any of the configured resourceTypes: " + configuredString;
        for (SnmpCollection collection : snmpCollections) {
            Groups groups = collection.getGroups();
            if (groups == null) continue;
            for (Group group : groups.getGroups()) {
                for (MibObj mibObj : group.getMibObjs()) {
                    String instance = mibObj.getInstance();
                    if (instance == null || "ifIndex".equals(instance) || allowedResourceTypes.contains(instance)) continue;
                    try {
                        if (Integer.parseInt(instance.trim()) >= 0) {
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    throw new IllegalArgumentException("instance '" + instance + "' invalid in mibObj definition for OID '" + mibObj.getOid() + "' in collection '" + collection.getName() + "' for group '" + group.getName() + "'.  Allowable instance values: " + allowableValues);
                }
            }
        }
    }

    private boolean systemDefMatches(SystemDef system, String aSysoid, String anAddress) {
        boolean bMatchSysoid = false;
        boolean isMask = false;
        String currSysoid = null;
        SystemDefChoice sysChoice = system.getSystemDefChoice();
        if (sysChoice.getSysoid() != null) {
            currSysoid = sysChoice.getSysoid();
        } else if (sysChoice.getSysoidMask() != null) {
            currSysoid = sysChoice.getSysoidMask();
            isMask = true;
        }
        if (currSysoid != null) {
            if (isMask) {
                if (aSysoid.startsWith(currSysoid)) {
                    LOG.debug("getMibObjectList: includes sysoid {} for system <name>: {}", (Object)aSysoid, (Object)system.getName());
                    bMatchSysoid = true;
                }
            } else if (aSysoid.equals(currSysoid)) {
                LOG.debug("getMibObjectList: includes sysoid {} for system <name>: {}", (Object)aSysoid, (Object)system.getName());
                bMatchSysoid = true;
            }
        }
        boolean bMatchIPAddress = true;
        if (bMatchSysoid && anAddress != null) {
            List addrList = null;
            List maskList = null;
            if (system.getIpList() != null) {
                addrList = system.getIpList().getIpAddresses();
                maskList = system.getIpList().getIpAddressMasks();
            }
            if (addrList != null && addrList.size() > 0 || maskList != null && maskList.size() > 0) {
                bMatchIPAddress = false;
            }
            if (addrList != null && addrList.size() > 0 && addrList.contains(anAddress)) {
                LOG.debug("getMibObjectList: addrList exists and does include IP address {} for system <name>: {}", (Object)anAddress, (Object)system.getName());
                bMatchIPAddress = true;
            }
            if (!bMatchIPAddress && maskList != null && maskList.size() > 0) {
                for (String currMask : maskList) {
                    if (anAddress.indexOf(currMask) != 0) continue;
                    LOG.debug("getMibObjectList: anAddress '{}' matches mask '{}'", (Object)anAddress, (Object)currMask);
                    bMatchIPAddress = true;
                    break;
                }
            }
        }
        return bMatchSysoid && bMatchIPAddress;
    }

    public DatacollectionConfig getRootDataCollection() {
        return (DatacollectionConfig)this.getContainer().getObject();
    }

    public List<String> getAvailableDataCollectionGroups() {
        return this.dataCollectionGroups;
    }

    public List<String> getAvailableSystemDefs() {
        ArrayList<String> systemDefs = new ArrayList<String>();
        for (SnmpCollection collection : ((DatacollectionConfig)this.getContainer().getObject()).getSnmpCollections()) {
            if (collection.getSystems() == null) continue;
            for (SystemDef systemDef : collection.getSystems().getSystemDefs()) {
                systemDefs.add(systemDef.getName());
            }
        }
        return systemDefs;
    }

    public List<String> getAvailableMibGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        for (SnmpCollection collection : ((DatacollectionConfig)this.getContainer().getObject()).getSnmpCollections()) {
            if (collection.getGroups() == null) continue;
            for (Group group : collection.getGroups().getGroups()) {
                groups.add(group.getName());
            }
        }
        return groups;
    }

    public void reload() {
        this.getContainer().reload();
    }

    public Date getLastUpdate() {
        this.getContainer().getObject();
        return new Date(this.getContainer().getLastUpdate());
    }
}

