/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.api.utils;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuffer slice(ByteBuffer buffer, int size) {
        if (buffer.position() + size > buffer.limit()) {
            new BufferUnderflowException();
        }
        ByteBuffer result = buffer.slice();
        buffer.position(buffer.position() + size);
        result.limit(size);
        return result;
    }

    public static float sfloat(ByteBuffer buffer) {
        return Float.intBitsToFloat(buffer.get() ^ buffer.get() << 8 ^ buffer.get() << 16 ^ buffer.get() << 24);
    }

    public static UnsignedLong uint(ByteBuffer buffer, int octets) {
        Preconditions.checkArgument((0 <= octets && octets <= 8 ? 1 : 0) != 0);
        long result = 0L;
        for (int i = 0; i < octets; ++i) {
            result = result << 8 | (long)buffer.get() & 0xFFL;
        }
        return UnsignedLong.fromLongBits((long)result);
    }

    public static Long sint(ByteBuffer buffer, int octets) {
        boolean s;
        Preconditions.checkArgument((0 <= octets && octets <= 8 ? 1 : 0) != 0);
        long result = (long)buffer.get() & 0xFFL;
        boolean bl = s = (result & 0x80L) != 0L;
        result = s ? 0xFFFFFFFFFFFFFF80L | result & 0x7FL : (result &= 0x7FL);
        for (int i = 1; i < octets; ++i) {
            result = result << 8 | (long)buffer.get() & 0xFFL;
        }
        return result;
    }

    public static int uint8(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    public static int uint16(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 0;
    }

    public static int uint24(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 0;
    }

    public static long uint32(ByteBuffer buffer) {
        return ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | ((long)buffer.get() & 0xFFL) << 0;
    }

    public static UnsignedLong uint64(ByteBuffer buffer) {
        return UnsignedLong.fromLongBits((long)(((long)buffer.get() & 0xFFL) << 56 | ((long)buffer.get() & 0xFFL) << 48 | ((long)buffer.get() & 0xFFL) << 40 | ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | ((long)buffer.get() & 0xFFL) << 0));
    }

    public static Integer sint8(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 0;
    }

    public static Integer sint16(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 0;
    }

    public static Integer sint24(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 0;
    }

    public static Integer sint32(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 24 | (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 0;
    }

    public static Long sint64(ByteBuffer buffer) {
        return ((long)buffer.get() & 0xFFL) << 56 | ((long)buffer.get() & 0xFFL) << 48 | ((long)buffer.get() & 0xFFL) << 40 | ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | ((long)buffer.get() & 0xFFL) << 0;
    }

    public static byte[] bytes(ByteBuffer buffer, int size) {
        byte[] result = new byte[size];
        buffer.get(result);
        return result;
    }

    public static void skip(ByteBuffer buffer, int size) {
        buffer.position(buffer.position() + size);
    }
}

