/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.offset;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.opennms.core.ipc.sink.kafka.offset.HostAndPort;
import org.opennms.core.ipc.sink.kafka.offset.KafkaOffset;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaOffsetProvider.class);
    private KafkaOffsetConsumerRunner consumerRunner;
    private final Properties kafkaConfig = new Properties();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("kafka-offset-consumer-%d").build();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(this.threadFactory);
    private static final Map<String, SimpleConsumer> consumerMap = new HashMap<String, SimpleConsumer>();
    private Map<String, Map<Integer, KafkaOffset>> consumerOffsetMap = new ConcurrentHashMap<String, Map<Integer, KafkaOffset>>();
    private Map<String, Long> consumerLagMap = new ConcurrentHashMap<String, Long>();
    private MetricRegistry kafkaOffsetMetrics = new MetricRegistry();
    private JmxReporter reporter = null;

    private long readOffsetMessageValue(ByteBuffer buffer) {
        buffer.getShort();
        long offset = buffer.getLong();
        return offset;
    }

    public SimpleConsumer getConsumer() {
        Object kafkaServer = this.kafkaConfig.get("bootstrap.servers");
        if (kafkaServer == null || !(kafkaServer instanceof String)) {
            throw new IllegalArgumentException("Kafka server is invalid");
        }
        String kafkaString = (String)kafkaServer;
        HostAndPort kafkaHost = HostAndPort.fromString(kafkaString);
        if (kafkaHost == null) {
            throw new IllegalArgumentException("Kafka server is invalid");
        }
        return this.getConsumer(kafkaHost.getHost(), kafkaHost.getPort());
    }

    public SimpleConsumer getConsumer(String host, int port) {
        SimpleConsumer consumer = consumerMap.get(host);
        if (consumer == null) {
            consumer = new SimpleConsumer(host, port, 100000, 65536, "OpenNMS-Kafka-Monitor");
            LOGGER.info("Created a new Kafka Consumer for host: " + host);
            consumerMap.put(host, consumer);
        }
        return consumer;
    }

    public Map<String, Map<Integer, KafkaOffset>> getConsumerOffsetMap() {
        return this.consumerOffsetMap;
    }

    public long getLastOffset(SimpleConsumer consumer, String topic, int partition, long whichTime) {
        long lastOffset = 0L;
        try {
            List<String> topics = Collections.singletonList(topic);
            TopicMetadataRequest req = new TopicMetadataRequest(topics);
            TopicMetadataResponse topicMetadataResponse = consumer.send(req);
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            block2: for (TopicMetadata topicMetadata : topicMetadataResponse.topicsMetadata()) {
                for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
                    if (partitionMetadata.partitionId() != partition) continue;
                    String partitionHost = partitionMetadata.leader().host();
                    consumer = this.getConsumer(partitionHost, partitionMetadata.leader().port());
                    continue block2;
                }
            }
            HashMap<TopicAndPartition, PartitionOffsetRequestInfo> requestInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
            requestInfo.put(topicAndPartition, new PartitionOffsetRequestInfo(whichTime, 1));
            OffsetRequest request = new OffsetRequest(requestInfo, kafka.api.OffsetRequest.CurrentVersion(), "OpenNMS-Kafka-Monitor");
            OffsetResponse response = consumer.getOffsetsBefore(request);
            if (response.hasError()) {
                LOGGER.error("Error fetching Offset Data from the Broker. Reason: {}", (Object)response.errorCode(topic, partition));
                lastOffset = 0L;
            }
            long[] offsets = response.offsets(topic, partition);
            lastOffset = offsets[0];
        }
        catch (Exception e) {
            LOGGER.error("Error while collecting the log Size for topic: {}:{} ", new Object[]{topic, partition, e});
        }
        return lastOffset;
    }

    public void closeConnection() throws InterruptedException {
        for (SimpleConsumer consumer : consumerMap.values()) {
            LOGGER.info("Closing connection for: " + consumer.host());
            consumer.close();
        }
    }

    public void start() {
        this.kafkaConfig.clear();
        this.kafkaConfig.put("group.id", SystemInfoUtils.getInstanceId());
        this.kafkaConfig.put("enable.auto.commit", "false");
        this.kafkaConfig.put("auto.offset.reset", "latest");
        this.kafkaConfig.put("key.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        this.kafkaConfig.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key;
            Object keyAsObject = entry.getKey();
            if (keyAsObject == null || !(keyAsObject instanceof String) || (key = (String)keyAsObject).length() <= "org.opennms.core.ipc.sink.kafka.".length() || !key.startsWith("org.opennms.core.ipc.sink.kafka.")) continue;
            String kafkaConfigKey = key.substring("org.opennms.core.ipc.sink.kafka.".length());
            this.kafkaConfig.put(kafkaConfigKey, entry.getValue());
        }
        this.consumerRunner = new KafkaOffsetConsumerRunner();
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.kafkaOffsetMetrics).inDomain("org.opennms.core.ipc.sink.kafka").build();
        this.reporter.start();
        this.executor.execute(this.consumerRunner);
    }

    public void stop() throws InterruptedException {
        this.reporter.stop();
        this.consumerRunner.shutdown();
        this.closeConnection();
    }

    private class KafkaOffsetConsumerRunner
    implements Runnable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final KafkaConsumer<byte[], byte[]> consumer;

        public KafkaOffsetConsumerRunner() {
            this.consumer = new KafkaConsumer(KafkaOffsetProvider.this.kafkaConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Logging.putPrefix((String)"ipc");
                this.consumer.subscribe(Arrays.asList("__consumer_offsets"));
                LOGGER.info("Connected to Kafka consumer offset topic");
                Schema schema = new Schema(new Field[]{new Field("group", Schema.STRING), new Field("topic", Schema.STRING), new Field("partition", Schema.INT32)});
                while (!this.closed.get()) {
                    ConsumerRecords records = this.consumer.poll(500L);
                    for (ConsumerRecord consumerRecord : records) {
                        ByteBuffer key;
                        short version;
                        if (consumerRecord.value() == null || consumerRecord.key() == null || (version = (key = ByteBuffer.wrap((byte[])consumerRecord.key())).getShort()) >= 2) continue;
                        try {
                            Struct struct = schema.read(key);
                            String group = struct.getString("group");
                            if (!group.equals(SystemInfoUtils.getInstanceId())) continue;
                            final String topic = struct.getString("topic");
                            int partition = struct.getInt("partition");
                            SimpleConsumer con = KafkaOffsetProvider.this.getConsumer();
                            long realOffset = KafkaOffsetProvider.this.getLastOffset(con, struct.getString("topic"), partition, -1L);
                            long consumerOffset = KafkaOffsetProvider.this.readOffsetMessageValue(ByteBuffer.wrap((byte[])consumerRecord.value()));
                            long lag = realOffset - consumerOffset;
                            KafkaOffset mon = new KafkaOffset(group, topic, partition, realOffset, consumerOffset, lag);
                            LOGGER.debug("group : {} , topic: {}:{} , offsets : {}-{}-{}", new Object[]{group, topic, partition, consumerOffset, realOffset, lag});
                            ConcurrentHashMap<Integer, KafkaOffset> map = (ConcurrentHashMap<Integer, KafkaOffset>)KafkaOffsetProvider.this.consumerOffsetMap.get(topic);
                            if (map == null) {
                                map = new ConcurrentHashMap<Integer, KafkaOffset>();
                                KafkaOffsetProvider.this.consumerOffsetMap.put(topic, map);
                                KafkaOffsetProvider.this.kafkaOffsetMetrics.register(MetricRegistry.name((String)topic, (String[])new String[]{"Lag"}), (Metric)new Gauge<Long>(){

                                    public Long getValue() {
                                        return (Long)KafkaOffsetProvider.this.consumerLagMap.get(topic);
                                    }
                                });
                            }
                            map.put(partition, mon);
                            long totalLag = 0L;
                            for (KafkaOffset offset : map.values()) {
                                totalLag += offset.getLag();
                            }
                            LOGGER.debug(" Total lag for topic {} is {} ", (Object)topic, (Object)totalLag);
                            KafkaOffsetProvider.this.consumerLagMap.put(topic, totalLag);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception while getting offset", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while getting offset", (Throwable)e);
            }
            finally {
                this.consumer.close();
            }
        }

        public void shutdown() {
            this.closed.set(true);
            this.consumer.wakeup();
        }
    }
}

