/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.support.ReloadStrategySupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed FileWatcherReloadStrategy")
public class FileWatcherReloadStrategy
extends ReloadStrategySupport {
    private String folder;
    private ExecutorService executorService;
    private WatchFileChangesTask task;

    public FileWatcherReloadStrategy() {
    }

    public FileWatcherReloadStrategy(String directory) {
        this.setFolder(directory);
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @ManagedAttribute(description="Folder being watched")
    public String getFolder() {
        return this.folder;
    }

    @ManagedAttribute(description="Whether the watcher is running")
    public boolean isRunning() {
        return this.task != null && this.task.isRunning();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.folder == null) {
            return;
        }
        File dir = new File(this.folder);
        if (dir.exists() && dir.isDirectory()) {
            this.log.info("Starting ReloadStrategy to watch directory: {}", (Object)dir);
            WatchEvent.Modifier modifier = null;
            String os = ObjectHelper.getSystemProperty("os.name", "");
            if (os.toLowerCase(Locale.US).startsWith("mac")) {
                Class<WatchEvent.Modifier> clazz = this.getCamelContext().getClassResolver().resolveClass("com.sun.nio.file.SensitivityWatchEventModifier", WatchEvent.Modifier.class);
                if (clazz != null) {
                    WatchEvent.Modifier[] modifiers;
                    for (WatchEvent.Modifier mod : modifiers = clazz.getEnumConstants()) {
                        if (!"HIGH".equals(mod.name())) continue;
                        modifier = mod;
                        break;
                    }
                }
                if (modifier != null) {
                    this.log.info("On Mac OS X the JDK WatchService is slow by default so enabling SensitivityWatchEventModifier.HIGH as workaround");
                } else {
                    this.log.warn("On Mac OS X the JDK WatchService is slow and it may take up till 10 seconds to notice file changes");
                }
            }
            try {
                Path path = dir.toPath();
                WatchService watcher = path.getFileSystem().newWatchService();
                if (modifier != null) {
                    path.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY}, modifier);
                } else {
                    path.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                this.task = new WatchFileChangesTask(watcher, path);
                this.executorService = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor(this, "FileWatcherReloadStrategy");
                this.executorService.submit(this.task);
            }
            catch (IOException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
            this.executorService = null;
        }
    }

    protected class WatchFileChangesTask
    implements Runnable {
        private final WatchService watcher;
        private final Path folder;
        private volatile boolean running;

        public WatchFileChangesTask(WatchService watcher, Path folder) {
            this.watcher = watcher;
            this.folder = folder;
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            FileWatcherReloadStrategy.this.log.debug("ReloadStrategy is starting watching folder: {}", (Object)this.folder);
            while (FileWatcherReloadStrategy.this.isStarting() || FileWatcherReloadStrategy.this.isRunAllowed()) {
                WatchKey key;
                this.running = true;
                try {
                    FileWatcherReloadStrategy.this.log.trace("ReloadStrategy is polling for file changes in directory: {}", (Object)this.folder);
                    key = this.watcher.poll(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    break;
                }
                if (key == null) continue;
                Iterator<WatchEvent<?>> ex = key.pollEvents().iterator();
                while (ex.hasNext()) {
                    WatchEvent<?> event;
                    WatchEvent<?> we = event = ex.next();
                    Path path = (Path)we.context();
                    String name = this.folder.resolve(path).toAbsolutePath().toFile().getAbsolutePath();
                    FileWatcherReloadStrategy.this.log.trace("Modified/Created file: {}", (Object)name);
                    if (!name.toLowerCase(Locale.US).endsWith(".xml")) continue;
                    FileWatcherReloadStrategy.this.log.debug("Modified/Created XML file: {}", (Object)name);
                    try {
                        FileInputStream fis = new FileInputStream(name);
                        FileWatcherReloadStrategy.this.onReloadXml(FileWatcherReloadStrategy.this.getCamelContext(), name, fis);
                        IOHelper.close((Closeable)fis);
                    }
                    catch (Exception e) {
                        FileWatcherReloadStrategy.this.log.warn("Error reloading routes from file: " + name + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                    }
                }
                boolean valid = key.reset();
                if (valid) continue;
                break;
            }
            this.running = false;
            FileWatcherReloadStrategy.this.log.info("ReloadStrategy is stopping watching folder: {}", (Object)this.folder);
        }
    }
}

