/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.core.wsman.exceptions.InvalidResourceURI;
import org.opennms.core.wsman.exceptions.WSManException;
import org.opennms.core.wsman.utils.ResponseHandlingUtils;
import org.opennms.core.wsman.utils.RetryNTimesLoop;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.wsman.Attrib;
import org.opennms.netmgt.config.wsman.Collection;
import org.opennms.netmgt.config.wsman.Definition;
import org.opennms.netmgt.config.wsman.Group;
import org.opennms.netmgt.config.wsman.Groups;
import org.opennms.netmgt.config.wsman.WsmanAgentConfig;
import org.opennms.netmgt.config.wsman.WsmanDatacollectionConfig;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.dao.WSManDataCollectionConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class WsManCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(WsManCollector.class);
    private static final String WSMAN_AGENT_CONFIG_KEY = "wsmanAgentConfig";
    private static final String WSMAN_GROUPS_KEY = "wsmanGroups";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<Definition>>("wsmanAgentConfig", Definition.class), new AbstractMap.SimpleEntry<String, Class<Groups>>("wsmanGroups", Groups.class)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    private WSManClientFactory m_factory = new CXFWSManClientFactory();
    private WSManDataCollectionConfigDao m_wsManDataCollectionConfigDao;
    private WSManConfigDao m_wsManConfigDao;
    private NodeDao m_nodeDao;

    public WsManCollector() {
        super(TYPE_MAP);
    }

    public void initialize() throws CollectionInitializationException {
        LOG.debug("initialize()");
        this.m_wsManConfigDao = (WSManConfigDao)BeanUtils.getBean((String)"daoContext", (String)"wsManConfigDao", WSManConfigDao.class);
        this.m_wsManDataCollectionConfigDao = (WSManDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"wsManDataCollectionConfigDao", WSManDataCollectionConfigDao.class);
        this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
        if (collectionName == null) {
            throw new IllegalArgumentException("Collector configuration does not include the required 'collection' parameter.");
        }
        Collection collection = this.m_wsManDataCollectionConfigDao.getCollectionByName(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException("No collection found with name: " + collectionName);
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        if (node == null) {
            throw new IllegalArgumentException("Could not find node with id: " + agent.getNodeId());
        }
        Definition agentConfig = this.m_wsManConfigDao.getAgentConfig(agent.getAddress());
        Groups groups = new Groups(this.m_wsManDataCollectionConfigDao.getGroupsForAgent(collection, agent, agentConfig, node));
        runtimeAttributes.put(WSMAN_AGENT_CONFIG_KEY, agentConfig);
        runtimeAttributes.put(WSMAN_GROUPS_KEY, groups);
        return runtimeAttributes;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        LOG.debug("collect({}, {}, {})", (Object)agent, parameters);
        WsmanAgentConfig config = (WsmanAgentConfig)parameters.get(WSMAN_AGENT_CONFIG_KEY);
        Groups groups = (Groups)parameters.get(WSMAN_GROUPS_KEY);
        WSManEndpoint endpoint = WSManConfigDao.getEndpoint(config, agent.getAddress());
        WSManClient client = this.m_factory.getClient(endpoint);
        CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder(agent);
        if (LOG.isDebugEnabled()) {
            String groupNames = groups.getGroups().stream().map(Group::getName).collect(Collectors.joining(", "));
            LOG.debug("Collecting attributes on {} from groups: {}", (Object)agent, (Object)groupNames);
        }
        for (Group group : groups.getGroups()) {
            try {
                this.collectGroupUsing(group, agent, client, config.getRetry() != null ? config.getRetry() : 0, collectionSetBuilder);
            }
            catch (InvalidResourceURI e) {
                LOG.info("Resource URI {} in group named {} is not available on {}.", new Object[]{group.getResourceUri(), group.getName(), agent});
            }
            catch (WSManException e) {
                throw new CollectionException(String.format("Collecting group '%s' on %s failed with '%s'. See logs for details.", group.getName(), agent, e.getMessage()), (Throwable)e);
            }
        }
        return collectionSetBuilder.build();
    }

    private void collectGroupUsing(Group group, CollectionAgent agent, WSManClient client, int retries, CollectionSetBuilder builder) throws CollectionException {
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        AtomicInteger instanceId = new AtomicInteger();
        Supplier<Resource> resourceSupplier = () -> nodeResource;
        if (!"node".equalsIgnoreCase(group.getResourceType())) {
            resourceSupplier = () -> {
                String instance = String.format("%s%d", group.getName(), instanceId.getAndIncrement());
                return new DeferredGenericTypeResource(nodeResource, group.getResourceType(), instance);
            };
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using resource {} for group named {}", (Object)resourceSupplier.get(), (Object)group.getName());
        }
        LinkedList nodes = Lists.newLinkedList();
        RetryNTimesLoop retryLoop = new RetryNTimesLoop(retries);
        while (retryLoop.shouldContinue()) {
            try {
                if (group.getFilter() == null) {
                    LOG.debug("Enumerating and pulling {} on {}.", (Object)group.getResourceUri(), (Object)client);
                    client.enumerateAndPull(group.getResourceUri(), (List)nodes, true);
                    break;
                }
                LOG.debug("Enumerating and pulling {} with dialect {} and filter {} on {}.", new Object[]{group.getResourceUri(), group.getDialect(), group.getFilter(), client});
                client.enumerateAndPullUsingFilter(group.getResourceUri(), group.getDialect(), group.getFilter(), (List)nodes, true);
                break;
            }
            catch (WSManException e) {
                retryLoop.takeException(e);
            }
        }
        LOG.debug("Found {} nodes.", (Object)nodes.size());
        WsManCollector.processEnumerationResults(group, builder, resourceSupplier, nodes);
    }

    public static void processEnumerationResults(Group group, CollectionSetBuilder builder, Supplier<Resource> resourceSupplier, List<Node> nodes) {
        for (Node node : nodes) {
            Resource resource = resourceSupplier.get();
            ListMultimap<String, String> elementValues = ResponseHandlingUtils.toMultiMap(node);
            LOG.debug("Element values: {}", elementValues);
            for (Attrib attrib : group.getAttrib()) {
                if (attrib.getFilter() != null && !ResponseHandlingUtils.matchesFilter(attrib.getFilter(), elementValues)) continue;
                String valueAsString = null;
                List attributeValues = elementValues.get((Object)attrib.getName());
                if (attributeValues.size() > 1 && attrib.getIndexOf() != null) {
                    try {
                        int index = ResponseHandlingUtils.getMatchingIndex(attrib.getIndexOf(), elementValues);
                        valueAsString = (String)attributeValues.get(index);
                    }
                    catch (NoSuchElementException e) {
                        LOG.warn("No index was matched by index-of rule '{}' for attribute {} with values: {}.", new Object[]{attrib.getIndexOf(), attrib.getName(), elementValues});
                    }
                } else {
                    valueAsString = (String)Iterables.getFirst((Iterable)elementValues.get((Object)attrib.getName()), null);
                }
                if (valueAsString == null) {
                    LOG.warn("No value found for attribute: {} in group: {}", (Object)attrib.getName(), (Object)group.getName());
                    continue;
                }
                builder.withAttribute(resource, group.getName(), attrib.getAlias(), valueAsString, attrib.getType());
            }
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        LOG.debug("getRrdRepository({})", (Object)collectionName);
        WsmanDatacollectionConfig config = this.m_wsManDataCollectionConfigDao.getConfig();
        Collection collection = this.m_wsManDataCollectionConfigDao.getCollectionByName(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException("No configuration found for collection with name: " + collectionName);
        }
        RrdRepository rrdRepository = new RrdRepository();
        rrdRepository.setStep(collection.getRrd().getStep());
        rrdRepository.setHeartBeat(2 * rrdRepository.getStep());
        rrdRepository.setRraList(collection.getRrd().getRra());
        rrdRepository.setRrdBaseDir(new File(config.getRrdRepository()));
        LOG.debug("Using RRD repository: {} for collection: {}", (Object)rrdRepository, (Object)collectionName);
        return rrdRepository;
    }

    public void setWSManConfigDao(WSManConfigDao wsManConfigDao) {
        this.m_wsManConfigDao = Objects.requireNonNull(wsManConfigDao);
    }

    public void setWSManDataCollectionConfigDao(WSManDataCollectionConfigDao wsManDataCollectionConfigDao) {
        this.m_wsManDataCollectionConfigDao = Objects.requireNonNull(wsManDataCollectionConfigDao);
    }

    public void setWSManClientFactory(WSManClientFactory factory) {
        this.m_factory = Objects.requireNonNull(factory);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = Objects.requireNonNull(nodeDao);
    }
}

