/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.model.BridgeElement;

public class Bridge {
    final Integer m_id;
    Integer m_rootPort;
    boolean m_isRootBridge = false;
    List<BridgeElement> m_elements = new ArrayList<BridgeElement>();

    public Bridge(Integer id) {
        this.m_id = id;
    }

    public Integer getRootPort() {
        return this.m_rootPort;
    }

    public void setRootPort(Integer rootPort) {
        this.m_rootPort = rootPort;
    }

    public boolean isRootBridge() {
        return this.m_isRootBridge;
    }

    public void setRootBridge(boolean isRootBridge) {
        this.m_isRootBridge = isRootBridge;
    }

    public Integer getId() {
        return this.m_id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bridge other = (Bridge)obj;
        return !(this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id));
    }

    public String printTopology() {
        StringBuilder strbfr = new StringBuilder();
        strbfr.append("bridge:[");
        strbfr.append(this.m_id);
        strbfr.append("], isrootbridge:");
        strbfr.append(this.m_isRootBridge);
        strbfr.append(" designated port:");
        strbfr.append(this.m_rootPort);
        strbfr.append("]\n");
        return strbfr.toString();
    }

    public void clearBridgeElement() {
        this.m_elements.clear();
    }

    public List<BridgeElement> getBridgeElements() {
        return this.m_elements;
    }

    public boolean addBridgeElement(BridgeElement element) {
        if (element.getNode().getId().intValue() == this.m_id.intValue()) {
            this.m_elements.add(element);
            return true;
        }
        return false;
    }
}

