/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.jna.sockaddr_in;

public class SunV4NativeSocket
extends NativeDatagramSocket {
    private static final int IP_TOS = 3;
    private final int m_sock;

    public SunV4NativeSocket(int family, int type, int protocol, int listenPort) throws Exception {
        this.m_sock = this.socket(family, type, protocol);
        sockaddr_in addr_in = new sockaddr_in(listenPort);
        this.bind(this.m_sock, addr_in, addr_in.size());
    }

    public native int bind(int var1, sockaddr_in var2, int var3) throws LastErrorException;

    public native int socket(int var1, int var2, int var3) throws LastErrorException;

    @Override
    public native int setsockopt(int var1, int var2, int var3, Pointer var4, int var5);

    public native int sendto(int var1, Buffer var2, int var3, int var4, sockaddr_in var5, int var6) throws LastErrorException;

    public native int recvfrom(int var1, Buffer var2, int var3, int var4, sockaddr_in var5, int[] var6) throws LastErrorException;

    public native int close(int var1) throws LastErrorException;

    @Override
    public int getSock() {
        return this.m_sock;
    }

    @Override
    public void setTrafficClass(int tc) throws IOException {
        IntByReference tc_ptr = new IntByReference(tc);
        try {
            this.setsockopt(this.getSock(), 0, 3, tc_ptr.getPointer(), Pointer.SIZE);
        }
        catch (LastErrorException e) {
            throw new IOException("setsockopt: " + this.strerror(e.getErrorCode()));
        }
    }

    @Override
    public void allowFragmentation(boolean frag) throws IOException {
        this.allowFragmentation(0, 10, frag);
    }

    @Override
    public int receive(NativeDatagramPacket p) {
        sockaddr_in in_addr = new sockaddr_in();
        int[] szRef = new int[]{in_addr.size()};
        ByteBuffer buf = p.getContent();
        int n = this.recvfrom(this.getSock(), buf, buf.capacity(), 0, in_addr, szRef);
        p.setLength(n);
        p.setAddress(in_addr.getAddress());
        p.setPort(in_addr.getPort());
        return n;
    }

    @Override
    public int send(NativeDatagramPacket p) {
        sockaddr_in destAddr = new sockaddr_in(p.getAddress(), p.getPort());
        ByteBuffer buf = p.getContent();
        return this.sendto(this.getSock(), buf, buf.remaining(), 0, destAddr, destAddr.size());
    }

    @Override
    public void close() {
        this.close(this.getSock());
    }

    static {
        Native.register((String)null);
    }
}

