/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.xml;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.xml.XmlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlSinkModule<S extends Message, T extends Message>
implements SinkModule<S, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXmlSinkModule.class);
    private final Class<T> messageClazz;
    private final ThreadLocal<XmlHandler<T>> messageXmlHandler = new ThreadLocal();

    public AbstractXmlSinkModule(Class<T> messageClazz) {
        this.messageClazz = Objects.requireNonNull(messageClazz);
    }

    public byte[] marshal(T message) {
        return this.getXmlHandler().marshal(message).getBytes(StandardCharsets.UTF_8);
    }

    public T unmarshal(byte[] bytes) {
        return (T)((Message)this.getXmlHandler().unmarshal(new String(bytes, StandardCharsets.UTF_8)));
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    private XmlHandler<T> getXmlHandler() {
        XmlHandler<T> xmlHandler = this.messageXmlHandler.get();
        if (xmlHandler == null) {
            xmlHandler = this.createXmlHandler(this.messageClazz);
            this.messageXmlHandler.set(xmlHandler);
        }
        return xmlHandler;
    }

    private <W> XmlHandler<W> createXmlHandler(Class<W> clazz) {
        try {
            return new XmlHandler(clazz);
        }
        catch (Throwable t) {
            LOG.warn("Creating the XmlHandler failed. Retrying.", t);
            return new XmlHandler(clazz);
        }
    }
}

