/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.opennms.core.ipc.sink.kafka.KafkaLocalMessageDispatcherFactory;
import org.opennms.core.logging.Logging;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<String> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaRemoteMessageDispatcherFactory.class);
    private final Properties kafkaConfig = new Properties();
    private ConfigurationAdmin configAdmin;
    private JmxReporter reporter;
    private KafkaProducer<String, byte[]> producer;

    public <S extends Message, T extends Message> String getModuleMetadata(SinkModule<S, T> module) {
        JmsQueueNameFactory topicNameFactory = new JmsQueueNameFactory("Sink", module.getId());
        return topicNameFactory.getName();
    }

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, String topic, T message) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.trace("dispatch({}): sending message {}", (Object)topic, message);
            ProducerRecord record = new ProducerRecord(topic, (Object)module.marshal(message));
            try {
                Future future = this.producer.send(record);
                future.get();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while sending message to topic {}.", (Object)topic, (Object)e);
            }
            catch (ExecutionException e) {
                LOG.error("Error occured while sending message to topic {}.", (Object)topic, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.registerJmxReporter();
            this.kafkaConfig.clear();
            this.kafkaConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
            this.kafkaConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
            Dictionary properties = this.configAdmin.getConfiguration("org.opennms.core.ipc.sink.kafka").getProperties();
            if (properties != null) {
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    this.kafkaConfig.put(key, properties.get(key));
                }
            }
            LOG.info("KafkaRemoteMessageDispatcherFactory: initializing the Kafka producer with: {}", (Object)this.kafkaConfig);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                this.producer = new KafkaProducer(this.kafkaConfig);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    private void registerJmxReporter() {
        if (this.reporter == null) {
            this.reporter = JmxReporter.forRegistry((MetricRegistry)this.getMetrics()).inDomain(KafkaLocalMessageDispatcherFactory.class.getPackage().getName()).build();
            this.reporter.start();
        }
    }

    public void destroy() {
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

