/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardHttpContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextElement
implements WhiteboardHttpContext {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContextElement.class);
    protected final ServiceReference serviceReference;
    private final HttpContextMapping contextMapping;
    protected boolean valid = true;

    public HttpContextElement(ServiceReference ref, HttpContextMapping contextMapping) {
        NullArgumentException.validateNotNull(ref, "service-reference");
        NullArgumentException.validateNotNull(contextMapping, "Context mapping");
        this.serviceReference = ref;
        this.contextMapping = contextMapping;
        String httpContextId = contextMapping.getHttpContextId();
        if (httpContextId == null || httpContextId.trim().length() == 0) {
            LOG.warn("Registered http context [" + this.getPusblishedPID() + "] did not contain a valid http context id");
            this.valid = false;
        }
    }

    public HttpContextMapping getHttpContextMapping() {
        return this.contextMapping;
    }

    public boolean isValid() {
        return this.valid;
    }

    public long getServiceID() {
        return (Long)this.serviceReference.getProperty("service.id");
    }

    protected String getPusblishedPID() {
        return (String)this.serviceReference.getProperty("service.pid");
    }
}

