/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.scr.command.ScrUtils;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.support.IdComparator;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

@Command(scope="scr", name="components", description="Display available components")
@Service
public class ListAction
extends ScrActionSupport {
    private final IdComparator idComparator = new IdComparator();

    @Override
    protected Object doScrAction(ServiceComponentRuntime serviceComponentRuntime) throws Exception {
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("State");
        table.column("Component Name");
        ArrayList configs = new ArrayList();
        for (ComponentDescriptionDTO component : serviceComponentRuntime.getComponentDescriptionDTOs(new Bundle[0])) {
            configs.addAll(serviceComponentRuntime.getComponentConfigurationDTOs(component));
        }
        Collections.sort(configs, this.idComparator);
        for (ComponentConfigurationDTO config : configs) {
            if (!this.showHidden && ScrActionSupport.isHiddenComponent(config)) continue;
            table.addRow().addContent(new Object[]{config.id, ScrUtils.getState(config.state), config.description.name});
        }
        table.print(System.out);
        return null;
    }
}

