/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.protocols.nsclient.NsclientCheckParams;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;

public abstract class CheckNsc {
    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("port", true, "the port to connect to");
        options.addOption("password", true, "the password to use when connecting");
        options.addOption("warning", true, "treat the response as a warning if the level is above this value");
        options.addOption("critical", true, "treat the response as a critical error if the level is above this value");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        List arguments = cmd.getArgList();
        if (arguments.size() < 2) {
            CheckNsc.usage(options, cmd);
            System.exit(1);
        }
        NsclientManager client = null;
        NsclientPacket response = null;
        NsclientCheckParams params = null;
        String host = (String)arguments.remove(0);
        String command = (String)arguments.remove(0);
        int warningLevel = 0;
        int criticalLevel = 0;
        int port = 1248;
        if (cmd.hasOption("warning")) {
            warningLevel = Integer.parseInt(cmd.getOptionValue("warning"));
        }
        if (cmd.hasOption("critical")) {
            criticalLevel = Integer.parseInt(cmd.getOptionValue("critical"));
        }
        if (cmd.hasOption("port")) {
            port = Integer.parseInt(cmd.getOptionValue("port"));
        }
        StringBuilder clientParams = new StringBuilder();
        if (!arguments.isEmpty()) {
            Iterator i = arguments.iterator();
            while (i.hasNext()) {
                clientParams.append((String)i.next());
                if (!i.hasNext()) continue;
                clientParams.append("&");
            }
        }
        try {
            client = new NsclientManager(host, port);
        }
        catch (Throwable e) {
            CheckNsc.usage(options, cmd, "An error occurred creating a new NsclientManager.", e);
        }
        if (cmd.hasOption("password")) {
            client.setPassword(cmd.getOptionValue("password"));
        }
        try {
            client.setTimeout(5000);
            client.init();
        }
        catch (Throwable e) {
            CheckNsc.usage(options, cmd, "An error occurred initializing the NsclientManager.", e);
        }
        try {
            params = new NsclientCheckParams(warningLevel, criticalLevel, clientParams.toString());
        }
        catch (Throwable e) {
            CheckNsc.usage(options, cmd, "An error occurred creating the parameter object.", e);
        }
        try {
            response = client.processCheckCommand(NsclientManager.convertStringToType(command), params);
        }
        catch (Throwable e) {
            CheckNsc.usage(options, cmd, "An error occurred processing the command.", e);
        }
        if (response == null) {
            CheckNsc.usage(options, cmd, "No response was returned.", null);
        } else {
            System.out.println("NsclientPlugin: " + command + ": " + NsclientPacket.convertStateToString(response.getResultCode()) + " (" + response.getResponse() + ")");
        }
    }

    private static void usage(Options options, CommandLine cmd, String error, Throwable e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("usage: CheckNsc [options] host command [arguments]", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    private static void usage(Options options, CommandLine cmd) {
        CheckNsc.usage(options, cmd, null, null);
    }
}

