/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.io.PrintWriter;

public class JSONWriter {
    private final PrintWriter pw;
    private boolean comma = false;

    public JSONWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public JSONWriter object() {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write("{");
        this.comma = false;
        return this;
    }

    public JSONWriter endObject() {
        this.pw.write(125);
        this.comma = true;
        return this;
    }

    public JSONWriter array() {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write("[");
        this.comma = false;
        return this;
    }

    public JSONWriter endArray() {
        this.pw.write(93);
        this.comma = true;
        return this;
    }

    public JSONWriter key(String key) {
        if (this.comma) {
            this.pw.write(44);
        }
        this.quote(key);
        this.pw.write(58);
        this.comma = false;
        return this;
    }

    public JSONWriter value(boolean b) {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write(b ? "true" : "false");
        this.comma = true;
        return this;
    }

    public JSONWriter value(double d) {
        return this.value(new Double(d));
    }

    public JSONWriter value(int i) {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write(String.valueOf(i));
        this.comma = true;
        return this;
    }

    public JSONWriter value(long l) {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write(String.valueOf(l));
        this.comma = true;
        return this;
    }

    public JSONWriter value(Object value) {
        if (this.comma) {
            this.pw.write(44);
        }
        if (value == null || value.equals(null)) {
            this.pw.write("null");
        } else if (value instanceof Boolean) {
            this.pw.write(value.toString());
        } else if (value instanceof Number) {
            String str = value.toString();
            if (str.indexOf(46) == -1 || str.indexOf(101) > 0 || str.indexOf(69) > 0) {
                this.pw.write(str);
            } else {
                while (str.endsWith("0")) {
                    str = str.substring(0, str.length() - 1);
                }
                if (str.endsWith(".")) {
                    str = str.substring(0, str.length() - 1);
                }
                this.pw.write(str);
            }
        } else {
            this.quote(value.toString());
        }
        this.comma = true;
        return this;
    }

    private void quote(String value) {
        this.pw.print('\"');
        int len = value.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    this.pw.print("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.pw.print("\\\\");
                    continue block10;
                }
                case '\b': {
                    this.pw.print("\\b");
                    continue block10;
                }
                case '\f': {
                    this.pw.print("\\f");
                    continue block10;
                }
                case '\n': {
                    this.pw.print("\\n");
                    continue block10;
                }
                case '\r': {
                    this.pw.print("\\r");
                    continue block10;
                }
                case '\t': {
                    this.pw.print("\\t");
                    continue block10;
                }
                case '/': {
                    this.pw.print("\\/");
                    continue block10;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                        String hex = Integer.toHexString(c);
                        this.pw.print("\\u");
                        for (int k = 0; k < 4 - hex.length(); ++k) {
                            this.pw.print('0');
                        }
                        this.pw.print(hex.toUpperCase());
                        continue block10;
                    }
                    this.pw.print(c);
                }
            }
        }
        this.pw.print('\"');
    }
}

