/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class CiscoIpSlaMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(CiscoIpSlaMonitor.class);
    private static final String SERVICE_NAME = "Cisco_IP_SLA";
    private static final String RTT_ADMIN_TAG_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.3";
    private static final String RTT_OPER_STATE_OID = ".1.3.6.1.4.1.9.9.42.1.2.9.1.10";
    private static final String RTT_LATEST_OPERSENSE_OID = ".1.3.6.1.4.1.9.9.42.1.2.10.1.2";
    private static final String RTT_ADMIN_THRESH_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.5";
    private static final String RTT_ADMIN_TYPE_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.4";
    private static final String RTT_LATEST_OID = ".1.3.6.1.4.1.9.9.42.1.2.10.1.1";

    public String serviceName() {
        return SERVICE_NAME;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String returnValue = "SNMP request failed or Cisco IP SLA tag ";
        boolean monitorThresh = false;
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = svc.getAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        String adminTag = ParameterMap.getKeyedString(parameters, (String)"admin-tag", null);
        if (adminTag == null) {
            LOG.debug("No IP SLA admin-tag parameter defined! ");
            status = PollStatus.unavailable((String)"No IP SLA admin-tag parameter defined! ");
            return status;
        }
        returnValue = returnValue + adminTag + " not found";
        String ignoreThreshold = ParameterMap.getKeyedString(parameters, (String)"ignore-thresh", null);
        if (ignoreThreshold == null) {
            LOG.debug("No ignoreThreshold parmater defined! ");
            status = PollStatus.unavailable((String)"No ignoreThreshold parmater defined! ");
            return status;
        }
        if (ignoreThreshold.equals("false")) {
            monitorThresh = true;
        }
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        try {
            LOG.debug("poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            Map tagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_TAG_OID));
            if (tagResults == null) {
                LOG.debug("No admin tags received! ");
                status = PollStatus.unavailable((String)"No admin tags received! ");
                return status;
            }
            for (SnmpInstId ipslaInstance : tagResults.keySet()) {
                if (!((SnmpValue)tagResults.get(ipslaInstance)).toString().equals(adminTag)) continue;
                Map operSenseResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_LATEST_OPERSENSE_OID));
                if (operSenseResults == null) {
                    LOG.debug("No latest oper sense received! ");
                    status = PollStatus.unavailable((String)"No latest oper sense received! ");
                    return status;
                }
                Map operStateResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_OPER_STATE_OID));
                if (operStateResults == null) {
                    LOG.debug("No oper state received! ");
                    status = PollStatus.unavailable((String)"No oper state received! ");
                    return status;
                }
                Map adminTypeResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_TYPE_OID));
                if (adminTypeResults == null) {
                    LOG.debug("No ip sla types received! ");
                    status = PollStatus.unavailable((String)"No ip sla types received! ");
                    return status;
                }
                Map latestRttResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_LATEST_OID));
                if (latestRttResults == null) {
                    LOG.debug("No ip sla latest RTT received! ");
                    status = PollStatus.unavailable((String)"No ip sla latest RTT received! ");
                    return status;
                }
                LOG.debug("poll: instance={} admin tag={} value={} oper state={} ignoreThreshold={} latest RTT{}", new Object[]{ipslaInstance.toInt(), adminTag, tagResults.get(ipslaInstance), operStateResults.get(ipslaInstance), ignoreThreshold, latestRttResults.get(ipslaInstance)});
                returnValue = "Cisco IP SLA tag " + adminTag + " with oper state " + this.resolveOperSate(((SnmpValue)operStateResults.get(ipslaInstance)).toInt()) + " returned with oper sense " + this.resolveOperSense(((SnmpValue)operSenseResults.get(ipslaInstance)).toInt()) + ". Configured IP SLA type is " + this.resolveAdminType(((SnmpValue)adminTypeResults.get(ipslaInstance)).toInt()) + ". Latest RTT is " + latestRttResults.get(ipslaInstance);
                LOG.debug(returnValue);
                if (monitorThresh && ((SnmpValue)operSenseResults.get(ipslaInstance)).toInt() == RTT_MON_OPER_SENSE.OVER_THRESHOLD.value()) {
                    Map threshResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_THRESH_OID));
                    if (monitorThresh && threshResults == null) {
                        LOG.debug("No ip sla thresholds received! ");
                        status = PollStatus.unavailable((String)"No ip sla thresholds received! ");
                        return status;
                    }
                    LOG.debug("IP SLA: {} threshold exceeded.", tagResults.get(ipslaInstance));
                    returnValue = returnValue + ". Monitoring threshold is enabled. Threshold value is " + threshResults.get(ipslaInstance);
                    return PollStatus.unavailable((String)returnValue);
                }
                if (((SnmpValue)operSenseResults.get(ipslaInstance)).toInt() != RTT_MON_OPER_SENSE.OK.value() && ((SnmpValue)operSenseResults.get(ipslaInstance)).toInt() != RTT_MON_OPER_SENSE.OVER_THRESHOLD.value()) continue;
                LOG.debug("Threshold is ignored rttMonLatestOperSense: {}", (Object)((SnmpValue)operSenseResults.get(ipslaInstance)).toInt());
                LOG.debug(returnValue);
                status = PollStatus.available((Double)Double.parseDouble(((SnmpValue)latestRttResults.get(ipslaInstance)).toString()));
                return status;
            }
            status = PollStatus.unavailable((String)returnValue);
        }
        catch (NullPointerException e) {
            String reason = "Unexpected error during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, (Throwable)e);
            status = PollStatus.unavailable((String)reason);
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable((String)reason);
        }
        return status;
    }

    private String resolveOperSate(int sc) {
        String name = "UNKNOWN";
        if (RTT_MON_OPER_STATE.RESET.value() == sc) {
            name = RTT_MON_OPER_STATE.RESET.name();
        }
        if (RTT_MON_OPER_STATE.ORDERLY_STOP.value() == sc) {
            name = RTT_MON_OPER_STATE.ORDERLY_STOP.name();
        }
        if (RTT_MON_OPER_STATE.IMMEDIATE_STOP.value() == sc) {
            name = RTT_MON_OPER_STATE.IMMEDIATE_STOP.name();
        }
        if (RTT_MON_OPER_STATE.PENDING.value() == sc) {
            name = RTT_MON_OPER_STATE.PENDING.name();
        }
        if (RTT_MON_OPER_STATE.INACTIVE.value() == sc) {
            name = RTT_MON_OPER_STATE.INACTIVE.name();
        }
        if (RTT_MON_OPER_STATE.ACTIVE.value() == sc) {
            name = RTT_MON_OPER_STATE.ACTIVE.name();
        }
        if (RTT_MON_OPER_STATE.RESTART.value() == sc) {
            name = RTT_MON_OPER_STATE.RESTART.name();
        }
        return name;
    }

    private String resolveOperSense(int sc) {
        String name = "UNKNOWN";
        if (RTT_MON_OPER_SENSE.OTHER.value() == sc) {
            name = RTT_MON_OPER_SENSE.OTHER.name();
        }
        if (RTT_MON_OPER_SENSE.OK.value() == sc) {
            name = RTT_MON_OPER_SENSE.OK.name();
        }
        if (RTT_MON_OPER_SENSE.DISCONNECTED.value() == sc) {
            name = RTT_MON_OPER_SENSE.DISCONNECTED.name();
        }
        if (RTT_MON_OPER_SENSE.OVER_THRESHOLD.value() == sc) {
            name = RTT_MON_OPER_SENSE.OVER_THRESHOLD.name();
        }
        if (RTT_MON_OPER_SENSE.TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.BUSY.value() == sc) {
            name = RTT_MON_OPER_SENSE.BUSY.name();
        }
        if (RTT_MON_OPER_SENSE.NOT_CONNECTED.value() == sc) {
            name = RTT_MON_OPER_SENSE.NOT_CONNECTED.name();
        }
        if (RTT_MON_OPER_SENSE.DROPPED.value() == sc) {
            name = RTT_MON_OPER_SENSE.DROPPED.name();
        }
        if (RTT_MON_OPER_SENSE.SEQUENCE_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.SEQUENCE_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.VERIFY_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.VERIFY_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.APPLICATION_SPECIFIC.value() == sc) {
            name = RTT_MON_OPER_SENSE.APPLICATION_SPECIFIC.name();
        }
        if (RTT_MON_OPER_SENSE.DNS_SERVER_TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.DNS_SERVER_TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.TCP_CONNECT_TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.TCP_CONNECT_TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.HTTP_TRANSACTION_TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.HTTP_TRANSACTION_TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.DNS_QUERY_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.DNS_QUERY_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.HTTP_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.HTTP_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.ERROR.name();
        }
        return name;
    }

    private String resolveAdminType(int sc) {
        String name = "UNKNOWN";
        if (RTT_MON_ADMIN_TYPE.ECHO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.ECHO.name();
        }
        if (RTT_MON_ADMIN_TYPE.PATH_ECHO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.PATH_ECHO.name();
        }
        if (RTT_MON_ADMIN_TYPE.FILE_IO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.FILE_IO.name();
        }
        if (RTT_MON_ADMIN_TYPE.SCRIPT.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.SCRIPT.name();
        }
        if (RTT_MON_ADMIN_TYPE.UDP_ECHO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.UDP_ECHO.name();
        }
        if (RTT_MON_ADMIN_TYPE.TCP_CONNECT.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.TCP_CONNECT.name();
        }
        if (RTT_MON_ADMIN_TYPE.HTTP.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.HTTP.name();
        }
        if (RTT_MON_ADMIN_TYPE.DNS.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.DNS.name();
        }
        if (RTT_MON_ADMIN_TYPE.JITTER.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.JITTER.name();
        }
        if (RTT_MON_ADMIN_TYPE.DLSW.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.DLSW.name();
        }
        if (RTT_MON_ADMIN_TYPE.DHCP.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.DHCP.name();
        }
        if (RTT_MON_ADMIN_TYPE.FTP.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.FTP.name();
        }
        return name;
    }

    private static enum RTT_MON_ADMIN_TYPE {
        ECHO(1),
        PATH_ECHO(2),
        FILE_IO(3),
        SCRIPT(4),
        UDP_ECHO(5),
        TCP_CONNECT(6),
        HTTP(7),
        DNS(8),
        JITTER(9),
        DLSW(10),
        DHCP(11),
        FTP(12);

        private final int state;

        private RTT_MON_ADMIN_TYPE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    private static enum RTT_MON_OPER_SENSE {
        OTHER(0),
        OK(1),
        DISCONNECTED(2),
        OVER_THRESHOLD(3),
        TIMEOUT(4),
        BUSY(5),
        NOT_CONNECTED(6),
        DROPPED(7),
        SEQUENCE_ERROR(8),
        VERIFY_ERROR(9),
        APPLICATION_SPECIFIC(10),
        DNS_SERVER_TIMEOUT(11),
        TCP_CONNECT_TIMEOUT(12),
        HTTP_TRANSACTION_TIMEOUT(13),
        DNS_QUERY_ERROR(14),
        HTTP_ERROR(15),
        ERROR(16);

        private final int state;

        private RTT_MON_OPER_SENSE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    private static enum RTT_MON_OPER_STATE {
        RESET(1),
        ORDERLY_STOP(2),
        IMMEDIATE_STOP(3),
        PENDING(4),
        INACTIVE(5),
        ACTIVE(6),
        RESTART(7);

        private final int state;

        private RTT_MON_OPER_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

