/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.wmi.wbem.jinterop;

import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.wbem.OnmsWbemProperty;

public class OnmsWbemPropertyImpl
implements OnmsWbemProperty {
    private IJIDispatch wbemPropertyDispatch;

    public OnmsWbemPropertyImpl(IJIDispatch wbemPropertyDispatch) {
        this.wbemPropertyDispatch = wbemPropertyDispatch;
    }

    @Override
    public String getWmiName() throws WmiException {
        return this.getWmiString("Name");
    }

    @Override
    public String getWmiOrigin() throws WmiException {
        return this.getWmiString("Origin");
    }

    @Override
    public Boolean getWmiIsArray() throws WmiException {
        return this.getWmiBoolean("IsArray");
    }

    @Override
    public Boolean getWmiIsLocal() throws WmiException {
        return this.getWmiBoolean("IsLocal");
    }

    @Override
    public Object getWmiValue() throws WmiException {
        try {
            return WmiClient.convertToNativeType(this.wbemPropertyDispatch.get("Value"));
        }
        catch (JIException e) {
            throw new WmiException("Unable to retrieve or convert WbemProperty Value attribute: " + e.getMessage(), e);
        }
    }

    @Override
    public Integer getWmiCIMType() throws WmiException {
        try {
            return this.wbemPropertyDispatch.get("CIMType").getObjectAsInt();
        }
        catch (JIException e) {
            throw new WmiException("Unable to retrieve WbemProperty CIMType attribute: " + e.getMessage(), e);
        }
    }

    private String getWmiString(String name) throws WmiException {
        try {
            return this.wbemPropertyDispatch.get(name).getObjectAsString2();
        }
        catch (JIException e) {
            throw new WmiException("Unable to retrieve WbemProperty " + name + " attribute: " + e.getMessage(), e);
        }
    }

    private Boolean getWmiBoolean(String name) throws WmiException {
        try {
            return this.wbemPropertyDispatch.get(name).getObjectAsBoolean();
        }
        catch (JIException e) {
            throw new WmiException("Unable to retrieve WbemProperty " + name + " attribute: " + e.getMessage(), e);
        }
    }
}

