/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.ipc;

import java.util.Objects;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.xml.AbstractXmlSinkModule;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.telemetry.ipc.ProtocolDefinition;
import org.opennms.netmgt.telemetry.ipc.TelemetryMessageDTO;
import org.opennms.netmgt.telemetry.ipc.TelemetryMessageLogDTO;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.springframework.beans.factory.annotation.Autowired;

public class TelemetrySinkModule
extends AbstractXmlSinkModule<TelemetryMessage, TelemetryMessageLogDTO> {
    private static final String MODULE_ID_PREFIX = "Telemetry.";
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_BATCH_INTERVAL_MS = 500;
    private static final int DEFAULT_QUEUE_SIZE = 10000;
    @Autowired
    private DistPollerDao distPollerDao;
    private final ProtocolDefinition protocol;
    private final String moduleId;

    public TelemetrySinkModule(ProtocolDefinition protocol) {
        super(TelemetryMessageLogDTO.class);
        this.protocol = Objects.requireNonNull(protocol);
        this.moduleId = MODULE_ID_PREFIX + protocol.getName();
    }

    public String getId() {
        return this.moduleId;
    }

    public int getNumConsumerThreads() {
        return this.protocol.getNumThreads().orElse(DEFAULT_NUM_THREADS);
    }

    public AggregationPolicy<TelemetryMessage, TelemetryMessageLogDTO> getAggregationPolicy() {
        final String systemId = this.distPollerDao.whoami().getId();
        final String systemLocation = this.distPollerDao.whoami().getLocation();
        return new AggregationPolicy<TelemetryMessage, TelemetryMessageLogDTO>(){

            public int getCompletionSize() {
                return TelemetrySinkModule.this.protocol.getBatchSize().orElse(1000);
            }

            public int getCompletionIntervalMs() {
                return TelemetrySinkModule.this.protocol.getBatchIntervalMs().orElse(500);
            }

            public Object key(TelemetryMessage telemetryMessage) {
                return telemetryMessage.getSource();
            }

            public TelemetryMessageLogDTO aggregate(TelemetryMessageLogDTO oldLog, TelemetryMessage message) {
                if (oldLog == null) {
                    oldLog = new TelemetryMessageLogDTO(systemLocation, systemId, message.getSource());
                }
                TelemetryMessageDTO messageDTO = new TelemetryMessageDTO(message.getBuffer());
                oldLog.getMessages().add(messageDTO);
                return oldLog;
            }
        };
    }

    public AsyncPolicy getAsyncPolicy() {
        return new AsyncPolicy(){

            public int getQueueSize() {
                return TelemetrySinkModule.this.protocol.getQueueSize().orElse(10000);
            }

            public int getNumThreads() {
                return TelemetrySinkModule.this.protocol.getNumThreads().orElse(DEFAULT_NUM_THREADS);
            }

            public boolean isBlockWhenFull() {
                return true;
            }
        };
    }

    public DistPollerDao getDistPollerDao() {
        return this.distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }
}

