/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeqOptimized$class;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.xml.parsing.TokenTests;

public abstract class TokenTests$class {
    public static final boolean isSpace(TokenTests $this, char ch) {
        boolean bl;
        switch (ch) {
            default: {
                bl = false;
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isSpace(TokenTests $this, Seq cs) {
        return cs.nonEmpty() && cs.forall(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char ch) {
                return this.$outer.isSpace(ch);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean isAlpha(TokenTests $this, char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAlphaDigit(TokenTests $this, char c) {
        return $this.isAlpha(c) || c >= '0' && c <= '9';
    }

    public static boolean isNameChar(TokenTests $this, char c) {
        return $this.isNameStart(c) || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameStart(TokenTests $this, char c) {
        if (c < '\u00c0') {
            if ($this.isAlpha(c)) return true;
            if (c == ':') return true;
            if (c != '_') return false;
            return true;
        }
        if (c < '\u0300') {
            if (c == '\u00d7') return false;
            if (c == '\u00f7') return false;
            return true;
        }
        if (c < '\u2000') {
            if (c < '\u0370') return false;
            if (c == '\u037e') return false;
            return true;
        }
        if (c < '\u3001') {
            if (c == '\u200c') return true;
            if (c == '\u200d') return true;
            Predef$ predef$ = Predef$.MODULE$;
            if (RichInt$.MODULE$.to$extension0(8304, 8591).contains(c)) return true;
            Predef$ predef$2 = Predef$.MODULE$;
            if (!RichInt$.MODULE$.to$extension0(11264, 12271).contains(c)) return false;
            return true;
        }
        if (c < '\ud800') {
            return true;
        }
        if (c >= '\u10000') return false;
        Predef$ predef$ = Predef$.MODULE$;
        if (RichInt$.MODULE$.to$extension0(63744, 64975).contains(c)) return true;
        Predef$ predef$3 = Predef$.MODULE$;
        if (!RichInt$.MODULE$.to$extension0(65008, 65533).contains(c)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isName(TokenTests $this, String s2) {
        Predef$ predef$ = Predef$.MODULE$;
        if (!TraversableOnce$class.nonEmpty(new StringOps(s2))) return false;
        Predef$ predef$2 = Predef$.MODULE$;
        if (!$this.isNameStart(BoxesRunTime.unboxToChar(IndexedSeqOptimized$class.head(new StringOps(s2))))) return false;
        Predef$ predef$3 = Predef$.MODULE$;
        String string2 = (String)IndexedSeqOptimized$class.tail(new StringOps(s2));
        Predef$ predef$4 = Predef$.MODULE$;
        if (!IndexedSeqOptimized$class.forall(new StringOps(string2), (Function1)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char c) {
                return this.$outer.isNameChar(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPubIDChar(TokenTests $this, char ch) {
        if ($this.isAlphaDigit(ch)) return true;
        if ($this.isSpace(ch)) {
            if (ch != '\t') return true;
        }
        Predef$ predef$ = Predef$.MODULE$;
        if (!new StringOps("-\\()+,./:=?;!*#@$_%").contains(BoxesRunTime.boxToCharacter(ch))) return false;
        return true;
    }

    public static boolean isValidIANAEncoding(TokenTests $this, Seq ianaEncoding) {
        return ianaEncoding.nonEmpty() && $this.isAlpha(BoxesRunTime.unboxToChar(ianaEncoding.head())) && ((IterableLike)ianaEncoding.tail()).forall(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char c) {
                return TokenTests$class.charOK$1(this.$outer, c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean checkSysID(TokenTests $this, String s2) {
        return ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{'\"', '\''}))).exists(new Serializable($this, s2){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final boolean apply(char c) {
                String string2 = this.s$1;
                Predef$ predef$ = Predef$.MODULE$;
                return !new StringOps(string2).contains(BoxesRunTime.boxToCharacter(c));
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public static boolean checkPubID(TokenTests $this, String s2) {
        Predef$ predef$ = Predef$.MODULE$;
        return IndexedSeqOptimized$class.forall(new StringOps(s2), (Function1)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char ch) {
                return this.$outer.isPubIDChar(ch);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean charOK$1(TokenTests $this, char c) {
        if ($this.isAlphaDigit(c)) return true;
        Predef$ predef$ = Predef$.MODULE$;
        if (!new StringOps("._-").contains(BoxesRunTime.boxToCharacter(c))) return false;
        return true;
    }

    public static void $init$(TokenTests $this) {
    }
}

