/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;

public class CIMProperty
extends CIMQualifiableElement
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 418624401577884269L;
    private CIMValue iValue;
    private String iOriginClass = null;
    private String iOverridingProperty;
    private CIMDataType iType;
    private boolean iPropagated = false;

    public CIMProperty() {
        this("");
    }

    public CIMProperty(String pName) {
        this(pName, null);
    }

    public CIMProperty(String pName, CIMValue pValue) {
        super(pName);
        this.iValue = pValue;
        if (pValue != null) {
            this.iType = pValue.getType();
        }
    }

    public Object clone() {
        return this.clone(true, true);
    }

    public Object clone(boolean pIncludeQualifier, boolean pIncludeClassOrigin) {
        CIMProperty that = new CIMProperty();
        that.iName = this.iName;
        if (this.iValue != null) {
            that.iValue = (CIMValue)this.iValue.clone();
        }
        if (pIncludeClassOrigin) {
            that.iOriginClass = this.iOriginClass;
        }
        that.iOverridingProperty = this.iOverridingProperty;
        that.iPropagated = this.iPropagated;
        if (this.iType != null) {
            that.iType = (CIMDataType)this.iType.clone();
        }
        if (pIncludeQualifier) {
            for (int i = 0; i < this.iQualifiers.size(); ++i) {
                that.iQualifiers.add(((CIMQualifier)this.iQualifiers.elementAt(i)).clone());
            }
        }
        return that;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CIMProperty)) {
            return false;
        }
        CIMProperty that = (CIMProperty)obj;
        if (!(this.iOriginClass != null ? this.iOriginClass.equalsIgnoreCase(that.iOriginClass) : that.iOriginClass == null)) {
            return false;
        }
        if (!(this.iOverridingProperty != null ? this.iOverridingProperty.equals(that.iOverridingProperty) : that.iOverridingProperty == null)) {
            return false;
        }
        if (this.iPropagated != that.iPropagated) {
            return false;
        }
        if (!this.iQualifiers.equals(that.iQualifiers)) {
            return false;
        }
        if (!(this.iType != null ? this.iType.equals(that.iType) : that.iType == null)) {
            return false;
        }
        if (!(this.iValue != null ? this.iValue.equals(that.iValue) : that.iValue == null)) {
            return false;
        }
        return this.iName.equalsIgnoreCase(that.iName);
    }

    public String getOriginClass() {
        return this.iOriginClass;
    }

    public String getOverridingProperty() {
        return this.iOverridingProperty;
    }

    public int getSize() {
        if (this.iValue != null) {
            return this.iValue.getSize();
        }
        if (this.iType != null) {
            return this.iType.getSize();
        }
        return -1;
    }

    public CIMValue getValue() {
        return this.iValue;
    }

    public CIMDataType getType() {
        return this.iType != null ? this.iType : (this.iValue != null ? this.iValue.getType() : null);
    }

    public boolean isKey() {
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase("Key") || qualifier.getValue() != null && !CIMValue.TRUE.equals(qualifier.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isPropagated() {
        return this.iPropagated;
    }

    public boolean isReference() {
        if (this.iType != null) {
            return this.iType.isReferenceType();
        }
        if (this.iValue != null && this.iValue.getType() != null) {
            return this.iValue.getType().isReferenceType();
        }
        return false;
    }

    public boolean removeQualifier(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null qualifier name exception");
        }
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase(pName)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public void setKey(boolean pKey) {
        if (pKey) {
            this.addQualifier(new CIMQualifier("Key"));
        } else {
            this.removeQualifier("Key");
        }
    }

    public void setOverridingProperty(String pNewOverridingProperty) {
        this.iOverridingProperty = pNewOverridingProperty;
    }

    public void setOriginClass(String pOriginClass) {
        this.iOriginClass = pOriginClass;
    }

    public void setPropagated(boolean pValue) {
        this.iPropagated = pValue;
    }

    public void setSize(int pSize) {
    }

    public void setType(CIMDataType pType) {
        if (this.iValue == null) {
            this.iType = pType;
        } else if (this.iValue.getType() != null && this.iValue.getType().getType() != pType.getType()) {
            throw new IllegalArgumentException("Specified data type does not match data type of argument value");
        }
    }

    public CIMQualifier setQualifier(CIMQualifier pQualifier) throws CIMException {
        if (pQualifier == null) {
            throw new IllegalArgumentException("null qualifier argument");
        }
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier q = (CIMQualifier)iter.next();
            if (!q.getName().equalsIgnoreCase(pQualifier.getName())) continue;
            q.setValue(pQualifier.getValue());
            return q;
        }
        throw new CIMException("CIM_ERR_NOT_FOUND");
    }

    public void setValue(CIMValue pValue) {
        if (this.iType != null && pValue != null && pValue.getType().getType() != this.iType.getType()) {
            throw new IllegalArgumentException("value type does not match property type");
        }
        this.iValue = pValue;
        if (this.iType == null && pValue != null) {
            this.iType = pValue.getType();
        }
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (this.iName != null && this.iName.length() > 0 && this.iQualifiers.size() > 0) {
            buf.append(CIMProperty.vectorToMOFString(this.iQualifiers, false, 1));
            buf.append('\n');
        }
        buf.append('\t');
        if (this.iType != null) {
            buf.append(this.iType.getStringType());
        } else {
            buf.append("null");
        }
        buf.append(' ');
        buf.append(this.iName);
        if (this.iType != null && this.iType.isArrayType()) {
            if (this.iType.getSize() > -1 && this.iType.getType() != 30) {
                buf.append("[");
                buf.append(this.iType.getSize());
                buf.append("]");
            } else {
                buf.append("[]");
            }
        }
        if (this.iValue != null) {
            buf.append(" = ");
            if (this.iValue == null) {
                buf.append("null");
            } else if (this.iValue.getType() != null && this.iValue.getType().isArrayType()) {
                buf.append('{');
                buf.append(CIMProperty.vectorToMOFString((Vector)this.iValue.getValue(), false, 0, 0, true));
                buf.append('}');
            } else {
                buf.append(this.iValue);
            }
        }
        buf.append(";\n");
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }
}

