/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import org.opennms.core.criteria.restrictions.Restriction;

public class Alias {
    private final String m_associationPath;
    private final String m_alias;
    private final JoinType m_type;
    private Restriction m_joinCondition;

    public Alias(String associationPath, String alias, JoinType type, Restriction joinCondition) {
        this.m_alias = alias.intern();
        this.m_associationPath = associationPath.intern();
        this.m_type = type;
        this.m_joinCondition = joinCondition;
    }

    public Alias(String associationPath, String alias, JoinType type) {
        this(associationPath, alias, type, null);
    }

    public String getAlias() {
        return this.m_alias;
    }

    public String getAssociationPath() {
        return this.m_associationPath;
    }

    public JoinType getType() {
        return this.m_type;
    }

    public boolean hasJoinCondition() {
        return this.m_joinCondition != null;
    }

    public Restriction getJoinCondition() {
        return this.m_joinCondition;
    }

    public void setJoinCondition(Restriction joinCondition) {
        this.m_joinCondition = joinCondition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_alias == null ? 0 : this.m_alias.hashCode());
        result = 31 * result + (this.m_associationPath == null ? 0 : this.m_associationPath.hashCode());
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        result = 31 * result + (this.m_joinCondition == null ? 0 : this.m_joinCondition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alias)) {
            return false;
        }
        Alias other = (Alias)obj;
        if (this.m_alias == null ? other.m_alias != null : !this.m_alias.equals(other.m_alias)) {
            return false;
        }
        if (this.m_associationPath == null ? other.m_associationPath != null : !this.m_associationPath.equals(other.m_associationPath)) {
            return false;
        }
        if (this.m_type != other.m_type) {
            return false;
        }
        if (this.m_joinCondition == null && other.m_joinCondition != null) {
            return false;
        }
        if (this.m_joinCondition != null && other.m_joinCondition == null) {
            return false;
        }
        return this.m_joinCondition.equals(other.m_joinCondition);
    }

    public String toString() {
        return "Alias [associationPath=" + this.m_associationPath + ", alias=" + this.m_alias + ", type=" + (Object)((Object)this.m_type) + ", joinCondition=" + this.m_joinCondition + "]";
    }

    public static enum JoinType {
        LEFT_JOIN,
        INNER_JOIN,
        FULL_JOIN;

    }

    public static interface AliasVisitor {
        public void visitAlias(String var1);

        public void visitAssociationPath(String var1);

        public void visitType(JoinType var1);
    }
}

