/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.swing;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class ExtensionsFileFilter
extends FileFilter {
    private Hashtable extensions_ = new Hashtable();

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public ExtensionsFileFilter(String[] extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            this.extensions_.put(extensions[i].toLowerCase(), extensions[i].toLowerCase());
        }
    }

    @Override
    public String getDescription() {
        StringBuffer ret = new StringBuffer();
        Enumeration enumm = this.extensions_.keys();
        while (enumm.hasMoreElements()) {
            String nxt = (String)enumm.nextElement();
            ret.append(nxt);
            ret.append(" ");
        }
        return ret.toString();
    }

    @Override
    public boolean accept(File f) {
        boolean ret = false;
        if (f.isDirectory()) {
            ret = true;
        } else {
            String extension = ExtensionsFileFilter.getExtension(f);
            if (extension != null && this.extensions_.containsKey(extension)) {
                ret = true;
            }
        }
        return ret;
    }
}

