/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurentlocks;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class Locks {
    public static <L extends Lock> void lockAll(Iterable<L> locks) {
        LinkedList<Lock> stack = new LinkedList<Lock>();
        try {
            for (Lock lock : locks) {
                lock.lock();
                stack.push(lock);
            }
        }
        catch (RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
    }

    public static <L extends Lock> void lockInterruptiblyAll(Iterable<L> locks) throws InterruptedException {
        LinkedList<Lock> stack = new LinkedList<Lock>();
        try {
            for (Lock lock : locks) {
                lock.lockInterruptibly();
                stack.push(lock);
            }
        }
        catch (InterruptedException e) {
            Locks.unlockAll(stack);
            throw e;
        }
        catch (RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
    }

    public static <L extends Lock> boolean tryLockAll(Iterable<L> locks) {
        LinkedList<Lock> stack = new LinkedList<Lock>();
        boolean success = false;
        try {
            Lock lock;
            Iterator<L> i$ = locks.iterator();
            while (i$.hasNext() && (success = (lock = (Lock)i$.next()).tryLock())) {
                stack.push(lock);
            }
        }
        catch (RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
        if (!success) {
            Locks.unlockAll(stack);
        }
        return success;
    }

    public static <L extends Lock> boolean tryLockAll(long time, TimeUnit unit, Iterable<L> locks) throws InterruptedException {
        LinkedList<Lock> stack = new LinkedList<Lock>();
        boolean success = false;
        try {
            long remainingNanos;
            Lock lock;
            long limitNanos = unit.toNanos(time);
            long startNanos = System.nanoTime();
            Iterator<L> i$ = locks.iterator();
            while (i$.hasNext() && (success = (lock = (Lock)i$.next()).tryLock(remainingNanos = !success ? limitNanos : limitNanos - (System.nanoTime() - startNanos), TimeUnit.NANOSECONDS))) {
                stack.push(lock);
            }
        }
        catch (RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
        catch (InterruptedException e) {
            Locks.unlockAll(stack);
            throw e;
        }
        if (!success) {
            Locks.unlockAll(stack);
        }
        return success;
    }

    public static <L extends Lock> void unlockAll(Iterable<L> locks) {
        for (Lock lock : locks) {
            lock.unlock();
        }
    }

    public static <L extends Lock> void lockAll(L ... locks) {
        Locks.lockAll(Arrays.asList(locks));
    }

    public static <L extends Lock> void lockInterruptiblyAll(L ... locks) throws InterruptedException {
        Locks.lockInterruptiblyAll(Arrays.asList(locks));
    }

    public static <L extends Lock> boolean tryLockAll(L ... locks) {
        return Locks.tryLockAll(Arrays.asList(locks));
    }

    public static <L extends Lock> boolean tryLockAll(long time, TimeUnit unit, L ... locks) throws InterruptedException {
        return Locks.tryLockAll(time, unit, Arrays.asList(locks));
    }

    public static <L extends Lock> void unlockAll(L ... locks) {
        Locks.unlockAll(Arrays.asList(locks));
    }

    Locks() {
    }
}

