/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SQSMessagingClientThreadFactory
implements ThreadFactory {
    private final String threadBaseName;
    private final AtomicInteger threadCounter;
    private final boolean isDaemon;
    private ThreadGroup threadGroup;

    public SQSMessagingClientThreadFactory(String taskName, boolean isDaemon) {
        this(taskName, isDaemon, false);
    }

    public SQSMessagingClientThreadFactory(String taskName, boolean isDaemon, boolean createWithThreadGroup) {
        this.threadBaseName = taskName + "Thread-";
        this.threadCounter = new AtomicInteger(0);
        this.isDaemon = isDaemon;
        if (createWithThreadGroup) {
            this.threadGroup = new ThreadGroup(taskName + "ThreadGroup");
            this.threadGroup.setDaemon(isDaemon);
        }
    }

    public SQSMessagingClientThreadFactory(String taskName, ThreadGroup threadGroup) {
        this.threadBaseName = taskName + "Thread-";
        this.threadCounter = new AtomicInteger(0);
        this.isDaemon = threadGroup.isDaemon();
        this.threadGroup = threadGroup;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t;
        if (this.threadGroup == null) {
            t = new Thread(r, this.threadBaseName + this.threadCounter.incrementAndGet());
            t.setDaemon(this.isDaemon);
        } else {
            t = new Thread(this.threadGroup, r, this.threadBaseName + this.threadCounter.incrementAndGet());
            t.setDaemon(this.isDaemon);
        }
        return t;
    }

    public boolean wasThreadCreatedWithThisThreadGroup(Thread thread) {
        if (this.threadGroup == null) {
            return false;
        }
        return thread.getThreadGroup() == this.threadGroup;
    }
}

