/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.ProviderConfiguration;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

public class SQSConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory {
    private final ProviderConfiguration providerConfiguration;
    private final AmazonSQSClientSupplier amazonSQSClientSupplier;

    public SQSConnectionFactory(ProviderConfiguration providerConfiguration) {
        this(providerConfiguration, AmazonSQSClientBuilder.standard());
    }

    public SQSConnectionFactory(ProviderConfiguration providerConfiguration, final AmazonSQS client) {
        if (providerConfiguration == null) {
            throw new IllegalArgumentException("Provider configuration cannot be null");
        }
        if (client == null) {
            throw new IllegalArgumentException("AmazonSQS client cannot be null");
        }
        this.providerConfiguration = providerConfiguration;
        this.amazonSQSClientSupplier = new AmazonSQSClientSupplier(){

            @Override
            public AmazonSQS get() {
                return client;
            }
        };
    }

    public SQSConnectionFactory(ProviderConfiguration providerConfiguration, final AmazonSQSClientBuilder clientBuilder) {
        if (providerConfiguration == null) {
            throw new IllegalArgumentException("Provider configuration cannot be null");
        }
        if (clientBuilder == null) {
            throw new IllegalArgumentException("AmazonSQS client builder cannot be null");
        }
        this.providerConfiguration = providerConfiguration;
        this.amazonSQSClientSupplier = new AmazonSQSClientSupplier(){

            @Override
            public AmazonSQS get() {
                return (AmazonSQS)clientBuilder.build();
            }
        };
    }

    private SQSConnectionFactory(final Builder builder) {
        this.providerConfiguration = builder.providerConfiguration;
        this.amazonSQSClientSupplier = new AmazonSQSClientSupplier(){

            @Override
            public AmazonSQS get() {
                AmazonSQSClient amazonSQSClient = new AmazonSQSClient(builder.awsCredentialsProvider, builder.clientConfiguration);
                if (builder.region != null) {
                    amazonSQSClient.setRegion(builder.region);
                }
                if (builder.endpoint != null) {
                    amazonSQSClient.setEndpoint(builder.endpoint);
                }
                if (builder.signerRegionOverride != null) {
                    amazonSQSClient.setSignerRegionOverride(builder.signerRegionOverride);
                }
                return amazonSQSClient;
            }
        };
    }

    public SQSConnection createConnection() throws JMSException {
        try {
            AmazonSQS amazonSQS = this.amazonSQSClientSupplier.get();
            return this.createConnection(amazonSQS, null);
        }
        catch (RuntimeException e) {
            throw (JMSException)new JMSException("Error creating SQS client: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    public SQSConnection createConnection(String awsAccessKeyId, String awsSecretKey) throws JMSException {
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretKey);
        return this.createConnection((AWSCredentials)basicAWSCredentials);
    }

    public SQSConnection createConnection(AWSCredentials awsCredentials) throws JMSException {
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider(awsCredentials);
        return this.createConnection((AWSCredentialsProvider)awsCredentialsProvider);
    }

    public SQSConnection createConnection(AWSCredentialsProvider awsCredentialsProvider) throws JMSException {
        try {
            AmazonSQS amazonSQS = this.amazonSQSClientSupplier.get();
            return this.createConnection(amazonSQS, awsCredentialsProvider);
        }
        catch (Exception e) {
            throw (JMSException)new JMSException("Error creating SQS client: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    private SQSConnection createConnection(AmazonSQS amazonSQS, AWSCredentialsProvider awsCredentialsProvider) throws JMSException {
        AmazonSQSMessagingClientWrapper amazonSQSClientJMSWrapper = new AmazonSQSMessagingClientWrapper(amazonSQS, awsCredentialsProvider);
        return new SQSConnection(amazonSQSClientJMSWrapper, this.providerConfiguration.getNumberOfMessagesToPrefetch());
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password);
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static class Builder {
        private Region region;
        private String endpoint;
        private String signerRegionOverride;
        private ClientConfiguration clientConfiguration;
        private AWSCredentialsProvider awsCredentialsProvider = new DefaultAWSCredentialsProviderChain();
        private ProviderConfiguration providerConfiguration = new ProviderConfiguration();

        public Builder(Region region) {
            this();
            this.region = region;
        }

        public Builder(String region) {
            this(Region.getRegion((Regions)Regions.fromName((String)region)));
        }

        public Builder() {
            this.clientConfiguration = new ClientConfiguration();
        }

        public Builder withRegion(Region region) {
            this.setRegion(region);
            return this;
        }

        public Builder withRegionName(String regionName) throws IllegalArgumentException {
            this.setRegion(Region.getRegion((Regions)Regions.fromName((String)regionName)));
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.setEndpoint(endpoint);
            return this;
        }

        public Builder withSignerRegionOverride(String signerRegionOverride) {
            this.setSignerRegionOverride(signerRegionOverride);
            return this;
        }

        public Builder withAWSCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
            this.setAwsCredentialsProvider(awsCredentialsProvider);
            return this;
        }

        public Builder withClientConfiguration(ClientConfiguration clientConfig) {
            this.setClientConfiguration(clientConfig);
            return this;
        }

        public Builder withNumberOfMessagesToPrefetch(int numberOfMessagesToPrefetch) {
            this.providerConfiguration.setNumberOfMessagesToPrefetch(numberOfMessagesToPrefetch);
            return this;
        }

        public SQSConnectionFactory build() {
            return new SQSConnectionFactory(this);
        }

        public Region getRegion() {
            return this.region;
        }

        public void setRegion(Region region) {
            this.region = region;
            this.endpoint = null;
        }

        public void setRegionName(String regionName) {
            this.setRegion(Region.getRegion((Regions)Regions.fromName((String)regionName)));
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            this.region = null;
        }

        public String getSignerRegionOverride() {
            return this.signerRegionOverride;
        }

        public void setSignerRegionOverride(String signerRegionOverride) {
            this.signerRegionOverride = signerRegionOverride;
        }

        public ClientConfiguration getClientConfiguration() {
            return this.clientConfiguration;
        }

        public void setClientConfiguration(ClientConfiguration clientConfig) {
            this.clientConfiguration = clientConfig;
        }

        public int getNumberOfMessagesToPrefetch() {
            return this.providerConfiguration.getNumberOfMessagesToPrefetch();
        }

        public void setNumberOfMessagesToPrefetch(int numberOfMessagesToPrefetch) {
            this.providerConfiguration.setNumberOfMessagesToPrefetch(numberOfMessagesToPrefetch);
        }

        public AWSCredentialsProvider getAwsCredentialsProvider() {
            return this.awsCredentialsProvider;
        }

        public void setAwsCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
            this.awsCredentialsProvider = awsCredentialsProvider;
        }
    }

    private static interface AmazonSQSClientSupplier {
        public AmazonSQS get();
    }
}

