/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.lang.reflect.Method;
import org.apache.camel.Consume;
import org.apache.camel.InOnly;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InOnly
public class DispatcherWhiteboard {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherWhiteboard.class);
    private BundleContext m_context;
    private Class<?> m_messageClass;
    private Class<?> m_serviceClass;
    private String m_methodName = "dispatch";
    private final String m_endpointUri;
    private ServiceTracker m_tracker = null;
    private Method m_method = null;

    public DispatcherWhiteboard(String endpointUri) {
        this.m_endpointUri = endpointUri;
        LOG.info("DispatcherWhiteboard for endpoint {} initialized.", (Object)endpointUri);
    }

    public String getEndpointUri() {
        return this.m_endpointUri;
    }

    public void setContext(BundleContext context) {
        this.m_context = context;
    }

    public Class<?> getMessageClass() {
        return this.m_messageClass;
    }

    public void setMessageClass(Class<?> messageClass) {
        this.m_messageClass = messageClass;
    }

    public void setMessageClass(String messageClass) throws ClassNotFoundException {
        this.m_messageClass = Class.forName(messageClass);
    }

    public Class<?> getServiceClass() {
        return this.m_serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.m_serviceClass = serviceClass;
    }

    public void setServiceClass(String serviceClass) throws ClassNotFoundException {
        this.m_serviceClass = Class.forName(serviceClass);
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public void setMethodName(String methodName) {
        this.m_methodName = methodName;
    }

    public void destroy() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
    }

    @Consume(property="endpointUri")
    public void dispatch(Object message) throws NoSuchMethodException, SecurityException {
        LOG.debug("dispatch: {}", message);
        if (this.m_tracker == null) {
            this.m_tracker = new ServiceTracker(this.m_context, this.m_serviceClass, null);
            this.m_tracker.open();
        }
        if (this.m_method == null) {
            this.m_method = this.m_serviceClass.getMethod(this.m_methodName, this.m_messageClass);
        }
        try {
            Object[] services = this.m_tracker.getServices();
            if (services != null && services.length > 0) {
                for (Object service : this.m_tracker.getServices()) {
                    this.m_method.invoke(service, message);
                }
            } else {
                LOG.warn("No dispatcher for message found. ServiceClass: {}, ServiceMethod: {}", this.m_serviceClass, (Object)this.m_methodName);
            }
        }
        catch (Throwable e) {
            LOG.warn("Message dispatch failed: " + e.getMessage(), e);
        }
    }
}

