/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.opennms.core.camel.CustomConfigurerException;
import org.opennms.core.utils.AnyServerX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpClientConfigurer
implements HttpClientConfigurer {
    private static final KeyManager[] EMPTY_KEYMANAGER_ARRAY = new KeyManager[0];
    private static final Logger LOG = LoggerFactory.getLogger(CustomHttpClientConfigurer.class);
    private String m_username = "admin";
    private String m_password = "admin";

    public void configureHttpClient(HttpClient client) {
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(EMPTY_KEYMANAGER_ARRAY, new TrustManager[]{new AnyServerX509TrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
            client.getParams().setAuthenticationPreemptive(true);
            LOG.debug("Configuring HTTP client with modified trust manager, username={}, password=xxxxxxxx", (Object)this.getUsername());
        }
        catch (Exception e) {
            throw new CustomConfigurerException(e);
        }
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }
}

