/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.net.Socket;
import org.opennms.core.utils.SocketWrapper;

public class TimeoutSocketFactory {
    private final int m_timeout;
    private final SocketWrapper m_socketWrapper;

    public TimeoutSocketFactory(int timeout) {
        this(timeout, null);
    }

    public TimeoutSocketFactory(int timeout, SocketWrapper wocketSrapper) {
        this.m_timeout = timeout;
        this.m_socketWrapper = wocketSrapper;
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket(host, port);
        socket.setSoTimeout(this.m_timeout);
        if (this.m_socketWrapper != null) {
            socket = this.m_socketWrapper.wrapSocket(socket);
        }
        return socket;
    }
}

