/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementAgent
extends ServiceSupport
implements ManagementAgent,
CamelContextAware {
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final int DEFAULT_CONNECTION_PORT = -1;
    public static final String DEFAULT_SERVICE_URL_PATH = "/jmxrmi/camel";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementAgent.class);
    private CamelContext camelContext;
    private MBeanServer server;
    private final ConcurrentMap<ObjectName, ObjectName> mbeansRegistered = new ConcurrentHashMap<ObjectName, ObjectName>();
    private JMXConnectorServer cs;
    private Registry registry;
    private Integer registryPort = 1099;
    private Integer connectorPort = -1;
    private String mBeanServerDefaultDomain = "org.apache.camel";
    private String mBeanObjectDomainName = "org.apache.camel";
    private String serviceUrlPath = "/jmxrmi/camel";
    private Boolean usePlatformMBeanServer = true;
    private Boolean createConnector = false;
    private Boolean onlyRegisterProcessorWithCustomId = false;
    private Boolean loadStatisticsEnabled = false;
    private Boolean endpointRuntimeStatisticsEnabled = true;
    private Boolean registerAlways = false;
    private Boolean registerNewRoutes = true;
    private Boolean mask = true;
    private Boolean includeHostName = false;
    private Boolean useHostIPAddress = false;
    private String managementNamePattern = "#name#";
    private ManagementStatisticsLevel statisticsLevel = ManagementStatisticsLevel.Default;

    public DefaultManagementAgent() {
    }

    public DefaultManagementAgent(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void finalizeSettings() throws Exception {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        if (System.getProperty("org.apache.camel.jmx.rmiConnector.registryPort") != null) {
            this.registryPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.registryPort");
            values.put("org.apache.camel.jmx.rmiConnector.registryPort", this.registryPort);
        }
        if (System.getProperty("org.apache.camel.jmx.rmiConnector.connectorPort") != null) {
            this.connectorPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.connectorPort");
            values.put("org.apache.camel.jmx.rmiConnector.connectorPort", this.connectorPort);
        }
        if (System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain") != null) {
            this.mBeanServerDefaultDomain = System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain");
            values.put("org.apache.camel.jmx.mbeanServerDefaultDomain", this.mBeanServerDefaultDomain);
        }
        if (System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName") != null) {
            this.mBeanObjectDomainName = System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName");
            values.put("org.apache.camel.jmx.mbeanObjectDomainName", this.mBeanObjectDomainName);
        }
        if (System.getProperty("org.apache.camel.jmx.serviceUrlPath") != null) {
            this.serviceUrlPath = System.getProperty("org.apache.camel.jmx.serviceUrlPath");
            values.put("org.apache.camel.jmx.serviceUrlPath", this.serviceUrlPath);
        }
        if (System.getProperty("org.apache.camel.jmx.createRmiConnector") != null) {
            this.createConnector = Boolean.getBoolean("org.apache.camel.jmx.createRmiConnector");
            values.put("org.apache.camel.jmx.createRmiConnector", this.createConnector);
        }
        if (System.getProperty("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId") != null) {
            this.onlyRegisterProcessorWithCustomId = Boolean.getBoolean("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId");
            values.put("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId", this.onlyRegisterProcessorWithCustomId);
        }
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null) {
            this.usePlatformMBeanServer = Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer");
            values.put("org.apache.camel.jmx.usePlatformMBeanServer", this.usePlatformMBeanServer);
        }
        if (System.getProperty("org.apache.camel.jmx.registerAlways") != null) {
            this.registerAlways = Boolean.getBoolean("org.apache.camel.jmx.registerAlways");
            values.put("org.apache.camel.jmx.registerAlways", this.registerAlways);
        }
        if (System.getProperty("org.apache.camel.jmx.registerNewRoutes") != null) {
            this.registerNewRoutes = Boolean.getBoolean("org.apache.camel.jmx.registerNewRoutes");
            values.put("org.apache.camel.jmx.registerNewRoutes", this.registerNewRoutes);
        }
        if (System.getProperty("org.apache.camel.jmx.mask") != null) {
            this.mask = Boolean.getBoolean("org.apache.camel.jmx.mask");
            values.put("org.apache.camel.jmx.mask", this.mask);
        }
        if (System.getProperty("org.apache.camel.jmx.includeHostName") != null) {
            this.includeHostName = Boolean.getBoolean("org.apache.camel.jmx.includeHostName");
            values.put("org.apache.camel.jmx.includeHostName", this.includeHostName);
        }
        if (System.getProperty("org.apache.camel.jmx.createRmiConnector") != null) {
            this.createConnector = Boolean.getBoolean("org.apache.camel.jmx.createRmiConnector");
            values.put("org.apache.camel.jmx.createRmiConnector", this.createConnector);
        }
        if (System.getProperty("org.apache.camel.jmx.loadStatisticsEnabled") != null) {
            this.loadStatisticsEnabled = Boolean.getBoolean("org.apache.camel.jmx.loadStatisticsEnabled");
            values.put("org.apache.camel.jmx.loadStatisticsEnabled", this.loadStatisticsEnabled);
        }
        if (System.getProperty("org.apache.camel.jmx.endpointRuntimeStatisticsEnabled") != null) {
            this.endpointRuntimeStatisticsEnabled = Boolean.getBoolean("org.apache.camel.jmx.endpointRuntimeStatisticsEnabled");
            values.put("org.apache.camel.jmx.endpointRuntimeStatisticsEnabled", this.endpointRuntimeStatisticsEnabled);
        }
        if (System.getProperty("org.apache.camel.jmx.statisticsLevel") != null) {
            this.statisticsLevel = this.camelContext.getTypeConverter().mandatoryConvertTo(ManagementStatisticsLevel.class, System.getProperty("org.apache.camel.jmx.statisticsLevel"));
            values.put("org.apache.camel.jmx.statisticsLevel", (Object)this.statisticsLevel);
        }
        if (System.getProperty("org.apache.camel.jmx.managementNamePattern") != null) {
            this.managementNamePattern = System.getProperty("org.apache.camel.jmx.managementNamePattern");
            values.put("org.apache.camel.jmx.managementNamePattern", this.managementNamePattern);
        }
        if (System.getProperty("org.apache.camel.jmx.useHostIPAddress") != null) {
            this.useHostIPAddress = Boolean.getBoolean("org.apache.camel.jmx.useHostIPAddress");
            values.put("org.apache.camel.jmx.useHostIPAddress", this.useHostIPAddress);
        }
        if (!values.isEmpty()) {
            LOG.info("ManagementAgent detected JVM system properties: {}", values);
        }
    }

    @Override
    public void setRegistryPort(Integer port) {
        this.registryPort = port;
    }

    @Override
    public Integer getRegistryPort() {
        return this.registryPort;
    }

    @Override
    public void setConnectorPort(Integer port) {
        this.connectorPort = port;
    }

    @Override
    public Integer getConnectorPort() {
        return this.connectorPort;
    }

    @Override
    public void setMBeanServerDefaultDomain(String domain) {
        this.mBeanServerDefaultDomain = domain;
    }

    @Override
    public String getMBeanServerDefaultDomain() {
        return this.mBeanServerDefaultDomain;
    }

    @Override
    public void setMBeanObjectDomainName(String domainName) {
        this.mBeanObjectDomainName = domainName;
    }

    @Override
    public String getMBeanObjectDomainName() {
        return this.mBeanObjectDomainName;
    }

    @Override
    public void setServiceUrlPath(String url) {
        this.serviceUrlPath = url;
    }

    @Override
    public String getServiceUrlPath() {
        return this.serviceUrlPath;
    }

    @Override
    public void setCreateConnector(Boolean flag) {
        this.createConnector = flag;
    }

    @Override
    public Boolean getCreateConnector() {
        return this.createConnector;
    }

    @Override
    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    @Override
    public Boolean getUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    @Override
    public Boolean getOnlyRegisterProcessorWithCustomId() {
        return this.onlyRegisterProcessorWithCustomId;
    }

    @Override
    public void setOnlyRegisterProcessorWithCustomId(Boolean onlyRegisterProcessorWithCustomId) {
        this.onlyRegisterProcessorWithCustomId = onlyRegisterProcessorWithCustomId;
    }

    @Override
    public void setMBeanServer(MBeanServer mbeanServer) {
        this.server = mbeanServer;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.server;
    }

    @Override
    public Boolean getRegisterAlways() {
        return this.registerAlways != null && this.registerAlways != false;
    }

    @Override
    public void setRegisterAlways(Boolean registerAlways) {
        this.registerAlways = registerAlways;
    }

    @Override
    public Boolean getRegisterNewRoutes() {
        return this.registerNewRoutes != null && this.registerNewRoutes != false;
    }

    @Override
    public void setRegisterNewRoutes(Boolean registerNewRoutes) {
        this.registerNewRoutes = registerNewRoutes;
    }

    @Override
    public Boolean getMask() {
        return this.mask != null && this.mask != false;
    }

    @Override
    public void setMask(Boolean mask) {
        this.mask = mask;
    }

    @Override
    public Boolean getIncludeHostName() {
        return this.includeHostName != null && this.includeHostName != false;
    }

    @Override
    public void setIncludeHostName(Boolean includeHostName) {
        this.includeHostName = includeHostName;
    }

    @Override
    public Boolean getUseHostIPAddress() {
        return this.useHostIPAddress != null && this.useHostIPAddress != false;
    }

    @Override
    public void setUseHostIPAddress(Boolean useHostIPAddress) {
        this.useHostIPAddress = useHostIPAddress;
    }

    @Override
    public String getManagementNamePattern() {
        return this.managementNamePattern;
    }

    @Override
    public void setManagementNamePattern(String managementNamePattern) {
        this.managementNamePattern = managementNamePattern;
    }

    @Override
    public Boolean getLoadStatisticsEnabled() {
        return this.loadStatisticsEnabled;
    }

    @Override
    public void setLoadStatisticsEnabled(Boolean loadStatisticsEnabled) {
        this.loadStatisticsEnabled = loadStatisticsEnabled;
    }

    @Override
    public Boolean getEndpointRuntimeStatisticsEnabled() {
        return this.endpointRuntimeStatisticsEnabled;
    }

    @Override
    public void setEndpointRuntimeStatisticsEnabled(Boolean endpointRuntimeStatisticsEnabled) {
        this.endpointRuntimeStatisticsEnabled = endpointRuntimeStatisticsEnabled;
    }

    @Override
    public ManagementStatisticsLevel getStatisticsLevel() {
        return this.statisticsLevel;
    }

    @Override
    public void setStatisticsLevel(ManagementStatisticsLevel statisticsLevel) {
        this.statisticsLevel = statisticsLevel;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    @Override
    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        block2: {
            try {
                this.registerMBeanWithServer(obj, name, forceRegistration);
            }
            catch (NotCompliantMBeanException e) {
                ManagementMBeanAssembler assembler = this.camelContext.getManagementMBeanAssembler();
                ObjectHelper.notNull(assembler, "ManagementMBeanAssembler", this.camelContext);
                ModelMBean mbean = assembler.assemble(this.server, obj, name);
                if (mbean == null) break block2;
                this.registerMBeanWithServer(mbean, name, forceRegistration);
            }
        }
    }

    @Override
    public void unregister(ObjectName name) throws JMException {
        if (this.isRegistered(name)) {
            ObjectName on = (ObjectName)this.mbeansRegistered.remove(name);
            this.server.unregisterMBean(on);
            LOG.debug("Unregistered MBean with ObjectName: {}", (Object)name);
        } else {
            this.mbeansRegistered.remove(name);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        if (this.server == null) {
            return false;
        }
        ObjectName on = (ObjectName)this.mbeansRegistered.get(name);
        return on != null && this.server.isRegistered(on) || this.server.isRegistered(name);
    }

    @Override
    public <T> T newProxyClient(ObjectName name, Class<T> mbean) {
        if (this.isRegistered(name)) {
            ObjectName on = (ObjectName)this.mbeansRegistered.get(name);
            return MBeanServerInvocationHandler.newProxyInstance(this.server, on != null ? on : name, mbean, false);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        if (this.server == null) {
            this.finalizeSettings();
            this.createMBeanServer();
        }
        LOG.debug("Starting JMX agent on server: {}", (Object)this.getMBeanServer());
    }

    @Override
    protected void doStop() throws Exception {
        if (this.cs != null) {
            try {
                this.cs.stop();
                LOG.debug("Stopped JMX Connector");
            }
            catch (IOException e) {
                LOG.debug("Error occurred during stopping JMXConnectorService: " + this.cs + ". This exception will be ignored.");
            }
            this.cs = null;
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                LOG.debug("Unexported JMX RMI Registry");
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Error occurred while unexporting JMX RMI registry. This exception will be ignored.");
            }
        }
        if (this.mbeansRegistered.isEmpty()) {
            return;
        }
        ObjectName[] mBeans = this.mbeansRegistered.keySet().toArray(new ObjectName[this.mbeansRegistered.size()]);
        int caught = 0;
        for (ObjectName name : mBeans) {
            try {
                this.unregister(name);
            }
            catch (Exception e) {
                LOG.info("Exception unregistering MBean with name " + name, (Throwable)e);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation. See INFO log for details.");
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        boolean exists = this.isRegistered(name);
        if (exists) {
            if (forceRegistration) {
                LOG.info("ForceRegistration enabled, unregistering existing MBean with ObjectName: {}", (Object)name);
                this.server.unregisterMBean(name);
            } else {
                LOG.debug("MBean already registered with ObjectName: {}", (Object)name);
            }
        }
        ObjectInstance instance = null;
        if (forceRegistration || !exists) {
            LOG.trace("Registering MBean with ObjectName: {}", (Object)name);
            instance = this.server.registerMBean(obj, name);
        }
        if (instance != null) {
            ObjectName registeredName = instance.getObjectName();
            LOG.debug("Registered MBean with ObjectName: {}", (Object)registeredName);
            this.mbeansRegistered.put(name, registeredName);
        }
    }

    protected void createMBeanServer() {
        String hostName;
        block11: {
            boolean canAccessSystemProps = true;
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPropertiesAccess();
                }
            }
            catch (SecurityException se) {
                canAccessSystemProps = false;
            }
            if (canAccessSystemProps) {
                try {
                    if (this.useHostIPAddress.booleanValue()) {
                        hostName = InetAddress.getLocalHost().getHostAddress();
                        break block11;
                    }
                    hostName = InetAddressUtil.getLocalHostName();
                }
                catch (UnknownHostException uhe) {
                    LOG.info("Cannot determine localhost name or address. Using default: 1099", (Throwable)uhe);
                    hostName = DEFAULT_HOST;
                }
            } else {
                hostName = DEFAULT_HOST;
            }
        }
        this.server = this.findOrCreateMBeanServer();
        try {
            if (this.createConnector.booleanValue()) {
                this.createJmxConnector(hostName);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Could not create and start JMX connector.", (Throwable)ioe);
        }
    }

    protected MBeanServer findOrCreateMBeanServer() {
        if (this.usePlatformMBeanServer.booleanValue()) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            LOG.debug("Found MBeanServer with default domain {}", (Object)server.getDefaultDomain());
            if (!this.mBeanServerDefaultDomain.equals(server.getDefaultDomain())) continue;
            return server;
        }
        return MBeanServerFactory.createMBeanServer(this.mBeanServerDefaultDomain);
    }

    protected void createJmxConnector(String host) throws IOException {
        ObjectHelper.notEmpty(this.serviceUrlPath, "serviceUrlPath");
        ObjectHelper.notNull(this.registryPort, "registryPort");
        try {
            this.registry = LocateRegistry.createRegistry(this.registryPort);
            LOG.debug("Created JMXConnector RMI registry on port {}", (Object)this.registryPort);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String path = this.serviceUrlPath.startsWith("/") ? this.serviceUrlPath : "/" + this.serviceUrlPath;
        final JMXServiceURL url = this.connectorPort > 0 ? new JMXServiceURL("service:jmx:rmi://" + host + ":" + this.connectorPort + "/jndi/rmi://" + host + ":" + this.registryPort + path) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + this.registryPort + path);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
        String threadName = this.camelContext.getExecutorServiceManager().resolveThreadName("JMXConnector: " + url);
        Thread thread = this.getCamelContext().getExecutorServiceManager().newThread(threadName, new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Staring JMX Connector thread to listen at: {}", (Object)url);
                    DefaultManagementAgent.this.cs.start();
                    LOG.info("JMX Connector thread started and listening at: {}", (Object)url);
                }
                catch (IOException ioe) {
                    LOG.warn("Could not start JMXConnector thread at: " + url + ". JMX Connector not in use.", (Throwable)ioe);
                }
            }
        });
        thread.start();
    }
}

