/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskDescription;
import com.vmware.vim25.TaskFilterSpec;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.TaskHistoryCollector;
import java.rmi.RemoteException;

public class TaskManager
extends ManagedObject {
    public TaskManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public TaskDescription getDescriptioin() {
        return this.getDescription();
    }

    public TaskDescription getDescription() {
        return (TaskDescription)this.getCurrentProperty("description");
    }

    public int getMaxCollector() {
        return (Integer)this.getCurrentProperty("maxCollector");
    }

    public Task[] getRecentTasks() {
        return this.getTasks("recentTask");
    }

    public TaskHistoryCollector createCollectorForTasks(TaskFilterSpec filter) throws InvalidState, RuntimeFault, RemoteException {
        return new TaskHistoryCollector(this.getServerConnection(), this.getVimService().createCollectorForTasks(this.getMOR(), filter));
    }

    public TaskInfo createTask(ManagedObject obj, String taskTypeId, String initiatedBy, boolean cancelable) throws RuntimeFault, RemoteException {
        return this.createTask(obj, taskTypeId, initiatedBy, cancelable, null);
    }

    public TaskInfo createTask(ManagedObject obj, String taskTypeId, String initiatedBy, boolean cancelable, String parentTaskKey) throws RuntimeFault, RemoteException {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null.");
        }
        return this.createTask(obj, taskTypeId, initiatedBy, cancelable, parentTaskKey, null);
    }

    public TaskInfo createTask(ManagedObject obj, String taskTypeId, String initiatedBy, boolean cancelable, String parentTaskKey, String activationId) throws RuntimeFault, RemoteException {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null.");
        }
        return this.getVimService().createTask(this.getMOR(), obj.getMOR(), taskTypeId, initiatedBy, cancelable, parentTaskKey, activationId);
    }
}

