/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.FileFault;
import com.vmware.vim25.FileTransferInformation;
import com.vmware.vim25.GuestAuthentication;
import com.vmware.vim25.GuestFileAttributes;
import com.vmware.vim25.GuestListFileInfo;
import com.vmware.vim25.GuestOperationsFault;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;

public class GuestFileManager
extends ManagedObject {
    private VirtualMachine vm = null;

    public GuestFileManager(ServerConnection sc, ManagedObjectReference mor, VirtualMachine vm) {
        super(sc, mor);
        this.vm = vm;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public void changeFileAttributesInGuest(GuestAuthentication auth, String guestFilePath, GuestFileAttributes fileAttributes) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        this.getVimService().changeFileAttributesInGuest(this.getMOR(), this.vm.getMOR(), auth, guestFilePath, fileAttributes);
    }

    public String createTemporaryDirectoryInGuest(GuestAuthentication auth, String prefix, String suffix, String directoryPath) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        return this.getVimService().createTemporaryDirectoryInGuest(this.getMOR(), this.vm.getMOR(), auth, prefix, suffix, directoryPath);
    }

    public String createTemporaryFileInGuest(GuestAuthentication auth, String prefix, String suffix, String directoryPath) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        return this.getVimService().createTemporaryFileInGuest(this.getMOR(), this.vm.getMOR(), auth, prefix, suffix, directoryPath);
    }

    public void deleteDirectoryInGuest(GuestAuthentication auth, String directoryPath, boolean recursive) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        this.getVimService().deleteDirectoryInGuest(this.getMOR(), this.vm.getMOR(), auth, directoryPath, recursive);
    }

    public void deleteFileInGuest(GuestAuthentication auth, String filePath) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        this.getVimService().deleteFileInGuest(this.getMOR(), this.vm.getMOR(), auth, filePath);
    }

    public FileTransferInformation initiateFileTransferFromGuest(GuestAuthentication auth, String guestFilePath) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        return this.getVimService().initiateFileTransferFromGuest(this.getMOR(), this.vm.getMOR(), auth, guestFilePath);
    }

    public String initiateFileTransferToGuest(GuestAuthentication auth, String guestFilePath, GuestFileAttributes fileAttributes, long fileSize, boolean overwrite) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        return this.getVimService().initiateFileTransferToGuest(this.getMOR(), this.vm.getMOR(), auth, guestFilePath, fileAttributes, fileSize, overwrite);
    }

    public GuestListFileInfo listFilesInGuest(GuestAuthentication auth, String filePath, int index, int maxResults, String matchPattern) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        return this.getVimService().listFilesInGuest(this.getMOR(), this.vm.getMOR(), auth, filePath, index, maxResults, matchPattern);
    }

    public void makeDirectoryInGuest(GuestAuthentication auth, String directoryPath, boolean createParentDirectories) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        this.getVimService().makeDirectoryInGuest(this.getMOR(), this.vm.getMOR(), auth, directoryPath, createParentDirectories);
    }

    public void moveDirectoryInGuest(GuestAuthentication auth, String srcDirectoryPath, String dstDirectoryPath) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        this.getVimService().moveDirectoryInGuest(this.getMOR(), this.vm.getMOR(), auth, srcDirectoryPath, dstDirectoryPath);
    }

    public void moveFileInGuest(GuestAuthentication auth, String srcFilePath, String dstFilePath, boolean overwrite) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        this.getVimService().moveFileInGuest(this.getMOR(), this.vm.getMOR(), auth, srcFilePath, dstFilePath, overwrite);
    }
}

