/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cf;

import com.vmware.vim.cf.NullObject;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.util.MorUtil;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;

class ManagedObjectCache
implements Observer {
    private Map<ManagedObjectReference, Map<String, Object>> items;
    private boolean isReady = false;
    private ServiceInstance si;

    ManagedObjectCache(ServiceInstance si) {
        this.si = si;
        this.items = new ConcurrentHashMap<ManagedObjectReference, Map<String, Object>>();
    }

    public Map<ManagedObjectReference, Map<String, Object>> getCachedItems() {
        return this.items;
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg instanceof PropertyFilterUpdate[]) {
            PropertyFilterUpdate[] pfus = (PropertyFilterUpdate[])arg;
            for (int i = 0; pfus != null && i < pfus.length; ++i) {
                ObjectUpdate[] ous = pfus[i].getObjectSet();
                for (int j = 0; ous != null && j < ous.length; ++j) {
                    ManagedObjectReference mor = ous[j].getObj();
                    if (!this.items.containsKey(mor)) {
                        this.items.put(mor, new ConcurrentHashMap());
                    }
                    Map<String, Object> moMap = this.items.get(mor);
                    PropertyChange[] pcs = ous[j].getChangeSet();
                    if (pcs == null) continue;
                    for (int k = 0; k < pcs.length; ++k) {
                        Object value = pcs[k].getVal();
                        value = value == null ? NullObject.NULL : value;
                        String propName = pcs[k].getName();
                        if (moMap.containsKey(propName)) {
                            moMap.put(propName, value);
                            continue;
                        }
                        String parentPropName = this.getExistingParentPropName(moMap, propName);
                        if (parentPropName != null) {
                            ManagedObject mo = MorUtil.createExactManagedObject(this.si.getServerConnection(), mor);
                            moMap.put(parentPropName, mo.getPropertyByPath(parentPropName));
                            continue;
                        }
                        moMap.put(propName, value);
                    }
                }
            }
        }
        this.isReady = true;
    }

    private String getExistingParentPropName(Map<String, Object> moMap, String propName) {
        int lastDot;
        int pos = propName.indexOf("[");
        if (pos != -1) {
            propName = propName.substring(0, pos);
        }
        do {
            if ((lastDot = propName.lastIndexOf(".")) != -1) continue;
            return null;
        } while (!moMap.containsKey(propName = propName.substring(0, lastDot)));
        return propName;
    }

    public boolean isReady() {
        return this.isReady;
    }
}

