/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import java.net.InetAddress;
import java.nio.ByteBuffer;

public class NativeDatagramPacket {
    private ByteBuffer m_data;
    private InetAddress m_address;
    private int m_port;

    public NativeDatagramPacket(ByteBuffer data, InetAddress address, int port) {
        this.m_data = data;
        this.m_address = address;
        this.m_port = port;
    }

    public NativeDatagramPacket(int size) {
        this(ByteBuffer.allocate(size), null, -1);
    }

    public NativeDatagramPacket(byte[] data, InetAddress host, int port) {
        this(ByteBuffer.wrap(data), host, port);
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress addr) {
        this.m_address = addr;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getLength() {
        return this.m_data.limit();
    }

    public void setLength(int length) {
        this.m_data.limit(length);
    }

    public ByteBuffer getContent() {
        return this.m_data.duplicate();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Address: ");
        buf.append(this.m_address);
        buf.append(" Port: ");
        buf.append(this.m_port);
        buf.append("\nData: ");
        ByteBuffer data = this.m_data.duplicate();
        buf.append(data.limit());
        buf.append(" Bytes\n");
        int bytesPerRow = 4;
        int limit = data.limit();
        int rows = (limit + 4) / 4;
        int index = 0;
        for (int i = 0; i < rows && index < limit; ++i) {
            for (int j = 0; j < 4 && index < limit; ++j) {
                buf.append(String.format("%02X", data.get(index++)));
            }
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }
}

