/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.jna.SocketUtils;
import org.opennms.jicmp.jna.bsd_sockaddr_in;

public class BSDV4NativeSocket
extends NativeDatagramSocket {
    private static final int IP_TOS = 3;
    private int m_sock;

    public BSDV4NativeSocket(int family, int type, int protocol, int listenPort) throws Exception {
        this.m_sock = this.socket(family, type, protocol);
        bsd_sockaddr_in in_addr = new bsd_sockaddr_in(listenPort);
        this.bind(this.m_sock, in_addr, in_addr.size());
    }

    public native int bind(int var1, bsd_sockaddr_in var2, int var3) throws LastErrorException;

    public native int socket(int var1, int var2, int var3) throws LastErrorException;

    @Override
    public native int setsockopt(int var1, int var2, int var3, Pointer var4, int var5);

    public native int sendto(int var1, Buffer var2, int var3, int var4, bsd_sockaddr_in var5, int var6) throws LastErrorException;

    public native int recvfrom(int var1, Buffer var2, int var3, int var4, bsd_sockaddr_in var5, int[] var6) throws LastErrorException;

    public native int close(int var1) throws LastErrorException;

    @Override
    public void setTrafficClass(int tc) throws IOException {
        IntByReference tc_ptr = new IntByReference(tc);
        try {
            this.setsockopt(this.getSock(), 0, 3, tc_ptr.getPointer(), Pointer.SIZE);
        }
        catch (LastErrorException e) {
            throw new IOException("setsockopt: " + this.strerror(e.getErrorCode()));
        }
    }

    @Override
    public void allowFragmentation(boolean frag) throws IOException {
        this.allowFragmentation(0, 10, frag);
    }

    @Override
    public int receive(NativeDatagramPacket p) {
        bsd_sockaddr_in in_addr = new bsd_sockaddr_in();
        int[] szRef = new int[]{in_addr.size()};
        ByteBuffer buf = p.getContent();
        int socket = this.getSock();
        SocketUtils.assertSocketValid(socket);
        int n = this.recvfrom(socket, buf, buf.capacity(), 0, in_addr, szRef);
        p.setLength(n);
        p.setAddress(in_addr.getAddress());
        p.setPort(in_addr.getPort());
        return n;
    }

    @Override
    public int send(NativeDatagramPacket p) {
        bsd_sockaddr_in destAddr = new bsd_sockaddr_in(p.getAddress(), p.getPort());
        ByteBuffer buf = p.getContent();
        int socket = this.getSock();
        SocketUtils.assertSocketValid(socket);
        return this.sendto(socket, buf, buf.remaining(), 0, destAddr, destAddr.size());
    }

    @Override
    public void close() {
        this.close(this.m_sock);
        this.m_sock = -1;
    }

    @Override
    public int getSock() {
        return this.m_sock;
    }

    static {
        Native.register((String)null);
    }
}

