/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.connection;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.jmx.connection.PasswordStrategy;

public class JmxConnectionConfig {
    private String factory;
    private InetAddress ipAddress;
    private String url;
    private String password;
    private String username;
    private boolean sunCacao;
    private String port;

    public String getFactory() {
        return this.factory;
    }

    public boolean isLocalConnection() throws MalformedURLException {
        Objects.requireNonNull(this.getIpAddress());
        Objects.requireNonNull(this.getPort());
        if (this.getIpAddress().isLoopbackAddress()) {
            String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
            if (this.getPort().equals(jmxPort) || jmxPort == null && "18980".equals(this.getPort())) {
                return true;
            }
        }
        return false;
    }

    public void setPort(String port) {
        this.port = port;
    }

    private String getPort() throws MalformedURLException {
        if (this.port == null && this.url != null) {
            this.port = String.valueOf(new JMXServiceURL(this.getUrl()).getPort());
        }
        return this.port;
    }

    public boolean hasCredentials() {
        return this.getUsername() != null && this.getPassword() != null;
    }

    public String[] getCredentials() {
        if (this.isSunCacao()) {
            return new String[]{"com.sun.cacao.user\u0001" + this.getUsername(), this.getPassword()};
        }
        return new String[]{this.getUsername(), this.getPassword()};
    }

    public PasswordStrategy getPasswordStategy() {
        if ("PASSWORD_CLEAR".equals(this.getFactory())) {
            return PasswordStrategy.PASSWORD_CLEAR;
        }
        if ("SASL".equals(this.getFactory())) {
            return PasswordStrategy.SASL;
        }
        return PasswordStrategy.STANDARD;
    }

    private boolean isSunCacao() {
        return this.sunCacao;
    }

    private String getPassword() {
        return this.password;
    }

    private String getUsername() {
        return this.username;
    }

    public String getUrl() throws MalformedURLException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (this.ipAddress != null) {
            propertiesMap.put("ipaddr", InetAddressUtils.toUrlIpAddress((InetAddress)this.getIpAddress()));
            String theUrl = PropertiesUtils.substitute((String)this.url, (Map[])new Map[]{propertiesMap});
            return theUrl;
        }
        return this.url;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public InetAddress getIpAddress() throws MalformedURLException {
        if (this.ipAddress == null && this.url != null) {
            this.ipAddress = InetAddressUtils.getInetAddress((String)new JMXServiceURL(this.getUrl()).getHost());
        }
        return this.ipAddress;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setSunCacao(boolean sunCacao) {
        this.sunCacao = sunCacao;
    }
}

