/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.Topology;

public class BridgePort
implements Topology {
    private Integer m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private Integer m_vlan;

    public static BridgePort getFromBridgeForwardingTableEntry(BridgeForwardingTableEntry link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNodeId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getFromBridgeMacLink(BridgeMacLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNode().getId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getFromBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNode().getId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getFromDesignatedBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getDesignatedNode().getId());
        bp.setBridgePort(link.getDesignatedPort());
        bp.setBridgePortIfIndex(link.getDesignatedPortIfIndex());
        bp.setVlan(link.getDesignatedVlan());
        return bp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_bridgePort == null ? 0 : this.m_bridgePort.hashCode());
        result = 31 * result + (this.m_node == null ? 0 : this.m_node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgePort other = (BridgePort)obj;
        if (this.m_bridgePort == null ? other.m_bridgePort != null : !this.m_bridgePort.equals(other.m_bridgePort)) {
            return false;
        }
        return !(this.m_node == null ? other.m_node != null : !this.m_node.equals(other.m_node));
    }

    public Integer getNodeId() {
        return this.m_node;
    }

    public void setNodeId(Integer node) {
        this.m_node = node;
    }

    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("nodeid:[");
        strbfr.append(this.getNodeId());
        strbfr.append("], bridgeport:[");
        strbfr.append(this.getBridgePort());
        strbfr.append("], ifindex:[");
        strbfr.append(this.getBridgePortIfIndex());
        strbfr.append("], vlan:[");
        strbfr.append(this.getVlan());
        strbfr.append("]");
        return strbfr.toString();
    }
}

