/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgePortWithMacs;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.Topology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeForwardingTable
implements Topology {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeForwardingTable.class);
    private final Bridge m_bridge;
    private final Set<BridgeForwardingTableEntry> m_entries;
    private Map<String, BridgePort> m_mactoport = new HashMap<String, BridgePort>();
    private Map<String, Set<BridgePort>> m_duplicated = new HashMap<String, Set<BridgePort>>();
    private Set<BridgePortWithMacs> m_porttomac = new HashSet<BridgePortWithMacs>();

    public static Set<BridgePortWithMacs> getThroughSet(BridgeForwardingTable bridgeFt, Set<BridgePort> excluded) throws BridgeTopologyException {
        for (BridgePort exclude : excluded) {
            if (exclude.getNodeId().intValue() == bridgeFt.getNodeId().intValue()) continue;
            throw new BridgeTopologyException("getThroughSet: node mismatch [" + bridgeFt.getNodeId() + "]", exclude);
        }
        HashSet<BridgePortWithMacs> throughSet = new HashSet<BridgePortWithMacs>();
        bridgeFt.getPorttomac().stream().filter(ptm -> !excluded.contains(ptm.getPort())).forEach(ptm -> throughSet.add((BridgePortWithMacs)ptm));
        return throughSet;
    }

    public static BridgeForwardingTable create(Bridge bridge, Set<BridgeForwardingTableEntry> entries) throws BridgeTopologyException {
        if (bridge == null) {
            throw new BridgeTopologyException("bridge must not be null");
        }
        if (entries == null) {
            throw new BridgeTopologyException("bridge forwarding table must not be null");
        }
        for (BridgeForwardingTableEntry link2 : entries) {
            if (link2.getNodeId().intValue() == bridge.getNodeId().intValue()) continue;
            throw new BridgeTopologyException("create: bridge:[" + bridge.getNodeId() + "] and forwarding table must have the same nodeid", link2);
        }
        BridgeForwardingTable bridgeFt = new BridgeForwardingTable(bridge, entries);
        entries.stream().filter(link -> link.getBridgeDot1qTpFdbStatus() == BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF).forEach(link -> {
            bridgeFt.getIdentifiers().add(link.getMacAddress());
            if (LOG.isDebugEnabled()) {
                LOG.debug("create: bridge:[{}] adding bid {}", (Object)bridge.getNodeId(), (Object)link.printTopology());
            }
        });
        for (BridgeForwardingTableEntry link3 : entries) {
            if (link3.getBridgeDot1qTpFdbStatus() != BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
            if (bridgeFt.getIdentifiers().contains(link3.getMacAddress())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("create: bridge:[{}] skip bid {}", (Object)bridge.getNodeId(), (Object)link3.printTopology());
                continue;
            }
            BridgePort bridgeport = BridgePort.getFromBridgeForwardingTableEntry(link3);
            BridgePortWithMacs bpwm = bridgeFt.getBridgePortWithMacs(bridgeport);
            if (bpwm == null) {
                bridgeFt.getPorttomac().add(BridgePortWithMacs.create(bridgeport, new HashSet<String>()));
            }
            bridgeFt.getBridgePortWithMacs(bridgeport).getMacs().add(link3.getMacAddress());
            if (bridgeFt.getMactoport().containsKey(link3.getMacAddress())) {
                bridgeFt.getDuplicated().put(link3.getMacAddress(), new HashSet());
                bridgeFt.getDuplicated().get(link3.getMacAddress()).add(bridgeport);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("create: bridge:[{}] duplicated {}", (Object)bridge.getNodeId(), (Object)link3.printTopology());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("create: bridge:[{}] adding {}", (Object)bridge.getNodeId(), (Object)link3.printTopology());
            }
            bridgeFt.getMactoport().put(link3.getMacAddress(), bridgeport);
        }
        for (String mac : bridgeFt.getDuplicated().keySet()) {
            BridgePort saved = bridgeFt.getMactoport().remove(mac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("create: bridge:[{}] remove duplicated [{}] from {}", new Object[]{bridge.getNodeId(), mac, saved.printTopology()});
            }
            BridgePortWithMacs savedwithmacs = bridgeFt.getBridgePortWithMacs(saved);
            savedwithmacs.getMacs().remove(mac);
            for (BridgePort dupli : bridgeFt.getDuplicated().get(mac)) {
                BridgePortWithMacs dupliwithmacs = bridgeFt.getBridgePortWithMacs(dupli);
                dupliwithmacs.getMacs().remove(mac);
            }
            bridgeFt.getDuplicated().get(mac).add(saved);
        }
        return bridgeFt;
    }

    private BridgeForwardingTable(Bridge bridge, Set<BridgeForwardingTableEntry> entries) {
        this.m_bridge = bridge;
        this.m_entries = entries;
    }

    public Set<BridgePortWithMacs> getPorttomac() {
        return this.m_porttomac;
    }

    public BridgePortWithMacs getBridgePortWithMacs(BridgePort port) {
        for (BridgePortWithMacs bpmx : this.m_porttomac) {
            if (!bpmx.getPort().equals(port)) continue;
            return bpmx;
        }
        return null;
    }

    public Map<String, BridgePort> getMactoport() {
        return this.m_mactoport;
    }

    public void setMactoport(Map<String, BridgePort> mactoport) {
        this.m_mactoport = mactoport;
    }

    public Map<String, Set<BridgePort>> getDuplicated() {
        return this.m_duplicated;
    }

    public void setDuplicated(Map<String, Set<BridgePort>> duplicated) {
        this.m_duplicated = duplicated;
    }

    public Set<BridgeForwardingTableEntry> getEntries() {
        return this.m_entries;
    }

    public int getBftSize() {
        return this.m_entries.size();
    }

    public Set<String> getBftMacs() {
        return this.m_mactoport.keySet();
    }

    public Integer getNodeId() {
        return this.m_bridge.getNodeId();
    }

    public Set<String> getIdentifiers() {
        return this.m_bridge.getIdentifiers();
    }

    public Bridge getBridge() {
        return this.m_bridge;
    }

    public Integer getRootBridgePort() {
        return this.m_bridge.getRootPort();
    }

    public BridgePort getRootPort() {
        return this.getPort(this.m_bridge.getRootPort());
    }

    public BridgePort getPort(Integer bp) {
        BridgePortWithMacs bpwm = (BridgePortWithMacs)this.m_porttomac.stream().filter(bpm -> bpm.getPort().getBridgePort() == bp).iterator().next();
        if (bpwm == null) {
            return null;
        }
        return bpwm.getPort();
    }

    public void setRootPort(Integer rootPort) {
        this.m_bridge.setRootPort(rootPort);
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append(this.m_bridge.printTopology());
        strbfr.append("\n");
        boolean rn = false;
        for (BridgeForwardingTableEntry bftentry : this.m_entries) {
            if (rn) {
                strbfr.append("\n");
            } else {
                rn = true;
            }
            strbfr.append(bftentry.printTopology());
        }
        return strbfr.toString();
    }
}

