/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class VlanStatus
implements Comparable<VlanStatus>,
Serializable {
    private static final long serialVersionUID = -5676188320482765289L;
    public static final int VLAN_STATUS_UNKNOWN = 0;
    public static final int CISCOVTP_VLAN_STATUS_OPERATIONAL = 1;
    public static final int CISCOVTP_VLAN_STATUS_SUSPENDED = 2;
    public static final int CISCOVTP_VLAN_STATUS_mtuTooBigForDevice = 3;
    public static final int CISCOVTP_VLAN_STATUS_mtuTooBigForTrunk = 4;
    public static final int ROWSTATUS_STARTING_INDEX = 4;
    public static final int SNMPV2C_ROWSTATUS_ACTIVE = 5;
    public static final int SNMPV2C_ROWSTATUS_NOTINSERVICE = 6;
    public static final int SNMPV2C_ROWSTATUS_NOTREADY = 7;
    public static final int SNMPV2C_ROWSTATUS_CREATEANDGO = 8;
    public static final int SNMPV2C_ROWSTATUS_CREATEANDWAIT = 9;
    public static final int SNMPV2C_ROWSTATUS_DESTROY = 10;
    private static final Integer[] s_order = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private Integer m_vlanStatus;
    private static final Map<Integer, String> vlanStatusMap = new HashMap<Integer, String>();
    public static final VlanStatus UNKNOWN;
    public static final VlanStatus CISCOVTP_OPERATIONAL;
    public static final VlanStatus CISCOVTP_SUSPENDED;
    public static final VlanStatus CISCOVTP_mtuTooBigForDevice;
    public static final VlanStatus CISCOVTP_mtuTooBigForTrunk;
    public static final VlanStatus ROWSTATUS_ACTIVE;
    public static final VlanStatus ROWSTATUS_NOTINSERVICE;
    public static final VlanStatus ROWSTATUS_NOTREADY;
    public static final VlanStatus ROWSTATUS_CREATEANDGO;
    public static final VlanStatus ROWSTATUS_CREATEANDWAIT;
    public static final VlanStatus ROWSTATUS_DESTROY;

    private VlanStatus() {
    }

    public VlanStatus(Integer vlanType) {
        this.m_vlanStatus = vlanType;
    }

    public Integer getIntCode() {
        return this.m_vlanStatus;
    }

    public void setIntCode(Integer vlanType) {
        this.m_vlanStatus = vlanType;
    }

    @Override
    public int compareTo(VlanStatus o) {
        return VlanStatus.getIndex(this.m_vlanStatus) - VlanStatus.getIndex(o.m_vlanStatus);
    }

    private static int getIndex(Integer code) {
        for (int i = 0; i < s_order.length; ++i) {
            if (s_order[i] != code) continue;
            return i;
        }
        throw new IllegalArgumentException("illegal vlanStatus code '" + code + "'");
    }

    public boolean equals(Object o) {
        if (o instanceof VlanStatus) {
            return this.m_vlanStatus.intValue() == ((VlanStatus)o).m_vlanStatus.intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.m_vlanStatus);
    }

    public static VlanStatus get(Integer code) {
        if (code == null) {
            return UNKNOWN;
        }
        switch (code) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return CISCOVTP_OPERATIONAL;
            }
            case 2: {
                return CISCOVTP_SUSPENDED;
            }
            case 3: {
                return CISCOVTP_mtuTooBigForDevice;
            }
            case 4: {
                return CISCOVTP_mtuTooBigForTrunk;
            }
            case 5: {
                return ROWSTATUS_ACTIVE;
            }
            case 6: {
                return ROWSTATUS_NOTINSERVICE;
            }
            case 7: {
                return ROWSTATUS_NOTREADY;
            }
            case 8: {
                return ROWSTATUS_CREATEANDGO;
            }
            case 9: {
                return ROWSTATUS_CREATEANDWAIT;
            }
            case 10: {
                return ROWSTATUS_DESTROY;
            }
        }
        throw new IllegalArgumentException("Cannot create vlanStatus from code " + code);
    }

    public static String getVlanStatusString(Integer code) {
        if (vlanStatusMap.containsKey(code)) {
            return vlanStatusMap.get(code);
        }
        return null;
    }

    static {
        vlanStatusMap.put(0, "unknown");
        vlanStatusMap.put(1, "operational");
        vlanStatusMap.put(2, "ciscovtp/suspended");
        vlanStatusMap.put(3, "ciscovtp/mtuTooBigForDevice");
        vlanStatusMap.put(4, "ciscovtp/mtuTooBigForTrunk");
        vlanStatusMap.put(5, "rowStatus/active");
        vlanStatusMap.put(6, "rowStatus/notInService");
        vlanStatusMap.put(7, "rowStatus/notReady");
        vlanStatusMap.put(8, "rowStatus/createAndGo");
        vlanStatusMap.put(9, "rowStatus/createAndWait");
        vlanStatusMap.put(10, "rowStatus/destroy");
        UNKNOWN = new VlanStatus(0);
        CISCOVTP_OPERATIONAL = new VlanStatus(1);
        CISCOVTP_SUSPENDED = new VlanStatus(2);
        CISCOVTP_mtuTooBigForDevice = new VlanStatus(3);
        CISCOVTP_mtuTooBigForTrunk = new VlanStatus(4);
        ROWSTATUS_ACTIVE = new VlanStatus(5);
        ROWSTATUS_NOTINSERVICE = new VlanStatus(6);
        ROWSTATUS_NOTREADY = new VlanStatus(7);
        ROWSTATUS_CREATEANDGO = new VlanStatus(8);
        ROWSTATUS_CREATEANDWAIT = new VlanStatus(9);
        ROWSTATUS_DESTROY = new VlanStatus(10);
    }
}

