/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.config.eventd.EventdConfiguration;

public class EventdConfigManager
implements EventdConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected EventdConfiguration m_config;

    public EventdConfigManager() throws IOException {
        this.reload();
    }

    EventdConfigManager(InputStream stream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stream);){
            this.m_config = (EventdConfiguration)JaxbUtils.unmarshal(EventdConfiguration.class, (Reader)isr);
        }
    }

    private void reload() throws IOException {
        try (FileReader r = new FileReader(ConfigFileConstants.getFile((int)ConfigFileConstants.EVENTD_CONFIG_FILE_NAME));){
            this.m_config = (EventdConfiguration)JaxbUtils.unmarshal(EventdConfiguration.class, (Reader)r);
        }
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public String getTCPIpAddress() {
        this.getReadLock().lock();
        try {
            String string = this.m_config.getTCPAddress().orElse(null);
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getTCPPort() {
        this.getReadLock().lock();
        try {
            int n = this.m_config.getTCPPort();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public String getUDPIpAddress() {
        this.getReadLock().lock();
        try {
            String string = this.m_config.getUDPAddress().orElse(null);
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getUDPPort() {
        this.getReadLock().lock();
        try {
            int n = this.m_config.getUDPPort();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getReceivers() {
        this.getReadLock().lock();
        try {
            int n = this.m_config.getReceivers();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getQueueLength() {
        this.getReadLock().lock();
        try {
            int n = this.m_config.getQueueLength().orElse(Integer.MAX_VALUE);
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public String getSocketSoTimeoutRequired() {
        this.getReadLock().lock();
        try {
            String string = this.m_config.getSocketSoTimeoutRequired();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getSocketSoTimeoutPeriod() {
        this.getReadLock().lock();
        try {
            int n = this.m_config.getSocketSoTimeoutPeriod().orElse(0);
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public boolean hasSocketSoTimeoutPeriod() {
        this.getReadLock().lock();
        try {
            boolean bl = this.m_config.getSocketSoTimeoutPeriod().isPresent();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public boolean shouldLogEventSummaries() {
        this.getReadLock().lock();
        try {
            boolean bl = this.m_config.getLogEventSummaries() == null ? false : this.m_config.getLogEventSummaries();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public String getGetNextEventID() {
        this.getReadLock().lock();
        try {
            String string = this.m_config.getGetNextEventID().orElse(null);
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

