/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.DefaultObjectSizeEstimator;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public abstract class AbstractTrafficShapingHandler
extends SimpleChannelHandler
implements ExternalResourceReleasable {
    static InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_TIME = 15000L;
    static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private ObjectSizeEstimator objectSizeEstimator;
    protected Timer timer;
    private volatile Timeout timeout;
    private long writeLimit;
    private long readLimit;
    protected long checkInterval = 1000L;
    protected long maxTime = 15000L;
    final AtomicBoolean release = new AtomicBoolean(false);

    private void init(ObjectSizeEstimator newObjectSizeEstimator, Timer newTimer, long newWriteLimit, long newReadLimit, long newCheckInterval, long newMaxTime) {
        this.objectSizeEstimator = newObjectSizeEstimator;
        this.timer = newTimer;
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        this.checkInterval = newCheckInterval;
        this.maxTime = newMaxTime;
    }

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer) {
        this.init(new DefaultObjectSizeEstimator(), timer, 0L, 0L, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        this.init(objectSizeEstimator, timer, 0L, 0L, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long checkInterval) {
        this.init(new DefaultObjectSizeEstimator(), timer, 0L, 0L, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        this.init(objectSizeEstimator, timer, 0L, 0L, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public void configure(long newCheckInterval) {
        this.setCheckInterval(newCheckInterval);
    }

    public long getWriteLimit() {
        return this.writeLimit;
    }

    public void setWriteLimit(long writeLimit) {
        this.writeLimit = writeLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public long getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(long readLimit) {
        this.readLimit = readLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    public long getMaxTimeWait() {
        return this.maxTime;
    }

    public void setMaxTimeWait(long maxTime) {
        this.maxTime = maxTime;
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        block7: {
            block9: {
                block8: {
                    try {
                        long wait;
                        long size = this.objectSizeEstimator.estimateSize(evt.getMessage());
                        if (size <= 0L || this.trafficCounter == null || (wait = this.trafficCounter.readTimeToWait(size, this.readLimit, this.maxTime)) < 10L) break block7;
                        if (this.release.get()) {
                            Object var10_5 = null;
                            break block8;
                        }
                        Channel channel = ctx.getChannel();
                        if (channel == null || !channel.isConnected()) break block7;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Read Suspend: " + wait + ":" + channel.isReadable() + ":" + (ctx.getAttachment() == null));
                        }
                        if (this.timer == null) {
                            Thread.sleep(wait);
                            break block9;
                        }
                        if (channel.isReadable() && ctx.getAttachment() == null) {
                            ctx.setAttachment(Boolean.TRUE);
                            channel.setReadable(false);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Suspend final status => " + channel.isReadable() + ":" + (ctx.getAttachment() == null));
                            }
                            ReopenReadTimerTask timerTask = new ReopenReadTimerTask(ctx);
                            this.timeout = this.timer.newTimeout(timerTask, wait, TimeUnit.MILLISECONDS);
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var10_8 = null;
                        super.messageReceived(ctx, evt);
                        throw throwable;
                    }
                }
                super.messageReceived(ctx, evt);
                return;
            }
            Object var10_6 = null;
            super.messageReceived(ctx, evt);
            return;
        }
        Object var10_7 = null;
        super.messageReceived(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        long wait;
        block7: {
            block8: {
                wait = 0L;
                try {
                    long size = this.objectSizeEstimator.estimateSize(evt.getMessage());
                    if (size <= 0L || this.trafficCounter == null) break block7;
                    wait = this.trafficCounter.writeTimeToWait(size, this.writeLimit, this.maxTime);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Write Suspend: " + wait + ":" + ctx.getChannel().isReadable() + ":" + (ctx.getAttachment() == null));
                    }
                    if (wait >= 10L) {
                        if (!this.release.get()) break block7;
                        Object var8_5 = null;
                        if (this.release.get()) {
                            return;
                        }
                        break block8;
                    }
                    wait = 0L;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (this.release.get()) {
                        return;
                    }
                    this.submitWrite(ctx, evt, wait);
                    throw throwable;
                }
            }
            this.submitWrite(ctx, evt, wait);
            return;
        }
        Object var8_6 = null;
        if (this.release.get()) {
            return;
        }
        this.submitWrite(ctx, evt, wait);
    }

    protected void internalSubmitWrite(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        super.writeRequested(ctx, evt);
    }

    protected abstract void submitWrite(ChannelHandlerContext var1, MessageEvent var2, long var3) throws Exception;

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return;
            }
        }
        super.handleDownstream(ctx, e);
    }

    public TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    public void releaseExternalResources() {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.release.set(true);
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    public String toString() {
        return "TrafficShaping with Write Limit: " + this.writeLimit + " Read Limit: " + this.readLimit + " and Counter: " + (this.trafficCounter != null ? this.trafficCounter.toString() : "none");
    }

    private class ReopenReadTimerTask
    implements TimerTask {
        final ChannelHandlerContext ctx;

        ReopenReadTimerTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeoutArg) throws Exception {
            if (AbstractTrafficShapingHandler.this.release.get()) {
                return;
            }
            if (!this.ctx.getChannel().isReadable() && this.ctx.getAttachment() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not Unsuspend: " + this.ctx.getChannel().isReadable() + ":" + (this.ctx.getAttachment() == null));
                }
                this.ctx.setAttachment(null);
            } else {
                if (logger.isDebugEnabled()) {
                    if (this.ctx.getChannel().isReadable() && this.ctx.getAttachment() != null) {
                        logger.debug("Unsuspend: " + this.ctx.getChannel().isReadable() + ":" + (this.ctx.getAttachment() == null));
                    } else {
                        logger.debug("Normal Unsuspend: " + this.ctx.getChannel().isReadable() + ":" + (this.ctx.getAttachment() == null));
                    }
                }
                this.ctx.setAttachment(null);
                this.ctx.getChannel().setReadable(true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Unsupsend final status => " + this.ctx.getChannel().isReadable() + ":" + (this.ctx.getAttachment() == null));
            }
        }
    }
}

