/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.aws.sqs;

import com.amazon.sqs.javamessaging.ProviderConfiguration;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.QueueNameExistsException;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSConfig;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSManager;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSQueueException;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAmazonSQSManager
implements AmazonSQSManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAmazonSQSManager.class);
    private final AmazonSQSConfig sqsConfig;
    private final Supplier<AmazonSQS> sqsClientSupplier = Suppliers.memoize(() -> this.createSQSClient());
    private LoadingCache<String, String> rpcQueueUrlsByName = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String queueName) {
            return DefaultAmazonSQSManager.this.ensureRpcQueueExists(queueName);
        }
    });
    private LoadingCache<String, String> sinkQueueUrlsById = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String moduleId) {
            String queueName = DefaultAmazonSQSManager.this.getSinkQueueName(moduleId);
            return DefaultAmazonSQSManager.this.ensureSinkQueueExists(queueName);
        }
    });

    public DefaultAmazonSQSManager(AmazonSQSConfig sqsConfig) {
        this.sqsConfig = Objects.requireNonNull(sqsConfig);
    }

    @Override
    public String getSinkQueueUrlAndCreateIfNecessary(String moduleId) throws InterruptedException {
        while (true) {
            try {
                return (String)this.sinkQueueUrlsById.get((Object)moduleId);
            }
            catch (ExecutionException e) {
                if (DefaultAmazonSQSManager.isCause(UnknownHostException.class, e) || DefaultAmazonSQSManager.isCause(SocketException.class, e)) {
                    LOG.warn("Cannot reach AWS while trying to retrieve the queue details for module {}, trying again in 5 seconds...", (Object)moduleId);
                    Thread.sleep(5000L);
                    continue;
                }
                throw new RuntimeException(e);
            }
            break;
        }
    }

    @Override
    public String getRpcRequestQueueNameAndCreateIfNecessary(String moduleId, String location) throws AmazonSQSQueueException {
        String rpcRequestQueueName = this.getRpcRequestQueueName(moduleId, location);
        try {
            this.rpcQueueUrlsByName.get((Object)rpcRequestQueueName);
            return rpcRequestQueueName;
        }
        catch (ExecutionException e) {
            throw new AmazonSQSQueueException(e);
        }
    }

    @Override
    public String getRpcReplyQueueNameAndCreateIfNecessary(String moduleId, String location) throws AmazonSQSQueueException {
        String rpcReplyQueueName = this.getRpcReplyQueueName(moduleId, location);
        try {
            this.rpcQueueUrlsByName.get((Object)rpcReplyQueueName);
            return rpcReplyQueueName;
        }
        catch (ExecutionException e) {
            throw new AmazonSQSQueueException(e);
        }
    }

    @Override
    public AmazonSQS getSQSClient() {
        return (AmazonSQS)this.sqsClientSupplier.get();
    }

    @Override
    public SQSConnectionFactory getSQSConnectionFactory() {
        return new SQSConnectionFactory(new ProviderConfiguration(), this.getSQSClient());
    }

    @Override
    public String sendMessage(String queueUrl, String body) throws InterruptedException {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(queueUrl, body);
        if (this.sqsConfig.getSinkQueueConfig().isFifoEnabled()) {
            sendMessageRequest.setMessageGroupId(queueUrl);
            if (!this.sqsConfig.getSinkQueueConfig().isFifoContentDedupEnabled()) {
                sendMessageRequest.setMessageDeduplicationId(Long.toString(System.nanoTime()));
            }
        }
        while (true) {
            try {
                return this.getSQSClient().sendMessage(sendMessageRequest).getMessageId();
            }
            catch (RuntimeException ex) {
                if (DefaultAmazonSQSManager.isCause(UnknownHostException.class, ex) || DefaultAmazonSQSManager.isCause(SocketException.class, ex)) {
                    LOG.warn("Cannot reach AWS at {} while trying to send a message, trying again in 5 seconds...", (Object)queueUrl);
                    Thread.sleep(5000L);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private AmazonSQS createSQSClient() {
        AmazonSQSClientBuilder builder = (AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withRegion(this.sqsConfig.getRegion());
        if (this.sqsConfig.hasStaticCredentials()) {
            BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.sqsConfig.getAccessKey(), this.sqsConfig.getSecretKey());
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds));
        }
        if (this.sqsConfig.isUseHttp()) {
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTP);
            builder.withClientConfiguration(clientConfig);
        }
        return (AmazonSQS)builder.build();
    }

    private String getRpcRequestQueueName(String moduleId, String location) {
        String queueName = String.format("%s-%s-%s", SystemInfoUtils.getInstanceId(), moduleId, location);
        if (!Strings.isNullOrEmpty((String)this.sqsConfig.getQueuePrefix())) {
            queueName = String.format("%s-%s", this.sqsConfig.getQueuePrefix(), queueName);
        }
        return queueName;
    }

    private String getRpcReplyQueueName(String moduleId, String location) {
        return this.getRpcRequestQueueName(moduleId, location) + "-Reply";
    }

    protected String getSinkQueueName(String moduleId) {
        String prefix = !Strings.isNullOrEmpty((String)this.sqsConfig.getQueuePrefix()) ? this.sqsConfig.getQueuePrefix() + "-" : "";
        String suffix = this.sqsConfig.getSinkQueueConfig().isFifoEnabled() ? ".fifo" : "";
        return String.format("%s%s-%s-%s%s", prefix, SystemInfoUtils.getInstanceId(), "Sink", moduleId, suffix);
    }

    private String ensureRpcQueueExists(String queueName) {
        Map<String, String> attributes = this.sqsConfig.getRpcQueueConfig().getAttributes();
        return this.ensureQueueExists(queueName, attributes);
    }

    private String ensureSinkQueueExists(String queueName) {
        Map<String, String> attributes = this.sqsConfig.getSinkQueueConfig().getAttributes();
        return this.ensureQueueExists(queueName, attributes);
    }

    private String ensureQueueExists(String queueName, Map<String, String> attributes) {
        AmazonSQS sqsClient = this.getSQSClient();
        try {
            return sqsClient.createQueue(new CreateQueueRequest(queueName).withAttributes(attributes)).getQueueUrl();
        }
        catch (QueueNameExistsException e) {
            String queueUrl = sqsClient.getQueueUrl(queueName).getQueueUrl();
            sqsClient.setQueueAttributes(new SetQueueAttributesRequest(queueUrl, attributes));
            return queueUrl;
        }
    }

    private static boolean isCause(Class<? extends Throwable> expected, Throwable exc) {
        return expected.isInstance(exc) || exc != null && DefaultAmazonSQSManager.isCause(expected, exc.getCause());
    }
}

