/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.detector.simple.client.LineOrientedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DominoIIOPClient
extends LineOrientedClient {
    private static final Logger LOG = LoggerFactory.getLogger(DominoIIOPClient.class);
    private int m_iorPort = 1000;

    @Override
    public void connect(InetAddress host, int port, int timeout) throws IOException, Exception {
        if (!this.preconnect(host, this.getIorPort(), timeout)) {
            throw new Exception("Failed to preconnect");
        }
    }

    private boolean preconnect(InetAddress host, int port, int timeout) throws IOException {
        return this.retrieveIORText(InetAddressUtils.str((InetAddress)host), port, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retrieveIORText(String hostAddress, int port, int timeout) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + hostAddress + ":" + port + "/diiop_ior.txt");
        try {
            URLConnection conn = u.openConnection();
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                isr = new InputStreamReader(conn.getInputStream());
                br = new BufferedReader(isr);
                boolean done = false;
                while (!done) {
                    String line = br.readLine();
                    if (line == null) {
                        done = true;
                        continue;
                    }
                    if (!(IOR = IOR + line).startsWith("IOR:")) continue;
                    done = true;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly((Reader)isr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
        }
        catch (SocketException e) {
            LOG.warn("Unable to connect to {}", (Object)u, (Object)e);
        }
        return IOR.startsWith("IOR:");
    }

    public void setIorPort(int iorPort) {
        this.m_iorPort = iorPort;
    }

    public int getIorPort() {
        return this.m_iorPort;
    }
}

