/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rtc;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="RTCConfiguration")
@ValidateUsing(value="rtc-configuration.xsd")
public class RTCConfiguration {
    @XmlAttribute(name="updaters", required=true)
    protected int m_updaters;
    @XmlAttribute(name="senders", required=true)
    protected int m_senders;
    @XmlAttribute(name="rollingWindow", required=true)
    protected String m_rollingWindow;
    @XmlAttribute(name="maxEventsBeforeResend", required=true)
    protected int m_maxEventsBeforeResend;
    @XmlAttribute(name="lowThresholdInterval", required=true)
    protected String m_lowThresholdInterval;
    @XmlAttribute(name="highThresholdInterval", required=true)
    protected String m_highThresholdInterval;
    @XmlAttribute(name="userRefreshInterval", required=true)
    protected String m_userRefreshInterval;
    @XmlAttribute(name="errorsBeforeUrlUnsubscribe", required=true)
    protected int m_errorsBeforeUrlUnsubscribe;

    public int getUpdaters() {
        return this.m_updaters;
    }

    public void setUpdaters(int value) {
        this.m_updaters = ConfigUtils.assertMinimumInclusive(value, 1L, "updaters");
    }

    public int getSenders() {
        return this.m_senders;
    }

    public void setSenders(int value) {
        this.m_senders = ConfigUtils.assertMinimumInclusive(value, 1L, "value");
    }

    public String getRollingWindow() {
        return this.m_rollingWindow;
    }

    public void setRollingWindow(String value) {
        this.m_rollingWindow = ConfigUtils.assertNotEmpty(value, "rollingWindow");
    }

    public int getMaxEventsBeforeResend() {
        return this.m_maxEventsBeforeResend;
    }

    public void setMaxEventsBeforeResend(int value) {
        this.m_maxEventsBeforeResend = value;
    }

    public String getLowThresholdInterval() {
        return this.m_lowThresholdInterval;
    }

    public void setLowThresholdInterval(String value) {
        this.m_lowThresholdInterval = ConfigUtils.assertNotEmpty(value, "lowThresholdInterval");
    }

    public String getHighThresholdInterval() {
        return this.m_highThresholdInterval;
    }

    public void setHighThresholdInterval(String value) {
        this.m_highThresholdInterval = ConfigUtils.assertNotEmpty(value, "highThresholdInterval");
    }

    public String getUserRefreshInterval() {
        return this.m_userRefreshInterval;
    }

    public void setUserRefreshInterval(String value) {
        this.m_userRefreshInterval = ConfigUtils.assertNotEmpty(value, "userRefreshInterval");
    }

    public int getErrorsBeforeUrlUnsubscribe() {
        return this.m_errorsBeforeUrlUnsubscribe;
    }

    public void setErrorsBeforeUrlUnsubscribe(int value) {
        this.m_errorsBeforeUrlUnsubscribe = value;
    }

    public int hashCode() {
        return Objects.hash(this.m_updaters, this.m_senders, this.m_rollingWindow, this.m_maxEventsBeforeResend, this.m_lowThresholdInterval, this.m_highThresholdInterval, this.m_userRefreshInterval, this.m_errorsBeforeUrlUnsubscribe);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RTCConfiguration) {
            RTCConfiguration that = (RTCConfiguration)obj;
            return Objects.equals(this.m_updaters, that.m_updaters) && Objects.equals(this.m_senders, that.m_senders) && Objects.equals(this.m_rollingWindow, that.m_rollingWindow) && Objects.equals(this.m_maxEventsBeforeResend, that.m_maxEventsBeforeResend) && Objects.equals(this.m_lowThresholdInterval, that.m_lowThresholdInterval) && Objects.equals(this.m_highThresholdInterval, that.m_highThresholdInterval) && Objects.equals(this.m_userRefreshInterval, that.m_userRefreshInterval) && Objects.equals(this.m_errorsBeforeUrlUnsubscribe, that.m_errorsBeforeUrlUnsubscribe);
        }
        return false;
    }
}

